/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.file.diff;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.beangle.commons.file.diff.bsdiff.Format;
import org.beangle.commons.file.diff.bsdiff.Format$;
import org.beangle.commons.file.diff.bsdiff.Format$Block$;
import org.beangle.commons.file.diff.bsdiff.Format$Header$;
import org.beangle.commons.file.diff.bsdiff.Offset$;
import org.beangle.commons.file.diff.bsdiff.SuffixSort;
import org.beangle.commons.file.diff.bsdiff.SuffixSort$;
import org.beangle.commons.io.Files$;
import scala.Int$;
import scala.runtime.ModuleSerializationProxy;

public final class Bsdiff$
implements Serializable {
    public static final Bsdiff$ MODULE$ = new Bsdiff$();

    private Bsdiff$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Bsdiff$.class);
    }

    public void diff(File oldFile, File newFile, File patchFile) {
        FileInputStream oldIn = new FileInputStream(oldFile);
        byte[] oldBytes = new byte[(int)oldFile.length()];
        oldIn.read(oldBytes);
        oldIn.close();
        FileInputStream newIn = new FileInputStream(newFile);
        byte[] newBytes = new byte[(int)newFile.length()];
        newIn.read(newBytes);
        newIn.close();
        Files$.MODULE$.touch(patchFile);
        FileOutputStream out = new FileOutputStream(patchFile);
        this.diff(oldBytes, newBytes, out);
        out.close();
    }

    public void diff(byte[] oldBytes, byte[] newBytes, OutputStream out) {
        CompressorStreamFactory compressor = new CompressorStreamFactory();
        int[] I = this.sort(oldBytes);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        CompressorOutputStream patchOut = compressor.createCompressorOutputStream(Format$.MODULE$.Compression(), (OutputStream)byteOut);
        int scan = 0;
        int len = 0;
        int position = 0;
        int lastScan = 0;
        int lastPos = 0;
        int lastOffset = 0;
        int oldScore = 0;
        int scsc = 0;
        int s = 0;
        int Sf = 0;
        int lenf = 0;
        int Sb = 0;
        int lenb = 0;
        int overlap = 0;
        int Ss = 0;
        int lens = 0;
        byte[] db = new byte[newBytes.length + 1];
        byte[] eb = new byte[newBytes.length + 1];
        int dblen = 0;
        int eblen = 0;
        while (scan < newBytes.length) {
            oldScore = 0;
            scsc = scan += len;
            boolean running = true;
            while (scan < newBytes.length && running) {
                SuffixSort.SearchResult result = SuffixSort$.MODULE$.search(I, oldBytes, 0, newBytes, scan, 0, oldBytes.length);
                len = result.length();
                position = result.position();
                while (scsc < scan + len) {
                    if (scsc + lastOffset < oldBytes.length && oldBytes[scsc + lastOffset] == newBytes[scsc]) {
                        ++oldScore;
                    }
                    ++scsc;
                }
                if (len == oldScore && len != 0 || len > oldScore + 8) {
                    running = false;
                    continue;
                }
                if (scan + lastOffset < oldBytes.length && oldBytes[scan + lastOffset] == newBytes[scan]) {
                    --oldScore;
                }
                ++scan;
            }
            if (len == oldScore && scan != newBytes.length) continue;
            s = 0;
            Sf = 0;
            lenf = 0;
            int i = 0;
            while (lastScan + i < scan && lastPos + i < oldBytes.length) {
                if (oldBytes[lastPos + i] == newBytes[lastScan + i]) {
                    ++s;
                }
                if (s * 2 - ++i <= Sf * 2 - lenf) continue;
                Sf = s;
                lenf = i;
            }
            lenb = 0;
            if (scan < newBytes.length) {
                s = 0;
                Sb = 0;
                for (int i2 = 1; scan >= lastScan + i2 && position >= i2; ++i2) {
                    if (oldBytes[position - i2] == newBytes[scan - i2]) {
                        ++s;
                    }
                    if (s * 2 - i2 <= Sb * 2 - lenb) continue;
                    Sb = s;
                    lenb = i2;
                }
            }
            if (lastScan + lenf > scan - lenb) {
                overlap = lastScan + lenf - (scan - lenb);
                s = 0;
                Ss = 0;
                lens = 0;
                for (int i3 = 0; i3 < overlap; ++i3) {
                    if (newBytes[lastScan + lenf - overlap + i3] == oldBytes[lastPos + lenf - overlap + i3]) {
                        ++s;
                    }
                    if (newBytes[scan - lenb + i3] == oldBytes[position - lenb + i3]) {
                        --s;
                    }
                    if (s <= Ss) continue;
                    Ss = s;
                    lens = i3 + 1;
                }
                lenf += lens - overlap;
                lenb -= lens;
            }
            for (i = 0; i < lenf; ++i) {
                db[dblen + i] = (byte)(db[dblen + i] | newBytes[lastScan + i] - oldBytes[lastPos + i]);
            }
            for (i = 0; i < scan - lenb - (lastScan + lenf); ++i) {
                eb[eblen + i] = newBytes[lastScan + lenf + i];
            }
            dblen += lenf;
            eblen += scan - lenb - (lastScan + lenf);
            Format.Block b = Format$Block$.MODULE$.apply(lenf, scan - lenb - (lastScan + lenf), position - lenb - (lastPos + lenf));
            Offset$.MODULE$.writeBlock(b, (OutputStream)patchOut);
            lastScan = scan - lenb;
            lastPos = position - lenb;
            lastOffset = position - scan;
        }
        patchOut.close();
        int controlLength = byteOut.size();
        patchOut = compressor.createCompressorOutputStream(Format$.MODULE$.Compression(), (OutputStream)byteOut);
        patchOut.write(db);
        patchOut.close();
        int diffLength = byteOut.size() - controlLength;
        patchOut = compressor.createCompressorOutputStream(Format$.MODULE$.Compression(), (OutputStream)byteOut);
        patchOut.write(eb);
        patchOut.close();
        Format.Header header = Format$Header$.MODULE$.apply(controlLength, diffLength, newBytes.length);
        Offset$.MODULE$.writeHeader(header, out);
        out.write(byteOut.toByteArray());
    }

    public void patch(byte[] old, byte[] patch, OutputStream out) {
        ByteArrayInputStream headerIn = new ByteArrayInputStream(patch);
        Format.Header header = Offset$.MODULE$.readHeader(headerIn);
        headerIn.close();
        ByteArrayInputStream controlIn = new ByteArrayInputStream(patch);
        ByteArrayInputStream dataIn = new ByteArrayInputStream(patch);
        ByteArrayInputStream extraIn = new ByteArrayInputStream(patch);
        try {
            ((InputStream)controlIn).skip(Int$.MODULE$.int2long(Format$.MODULE$.HeaderLength()));
            ((InputStream)dataIn).skip(Int$.MODULE$.int2long(Format$.MODULE$.HeaderLength() + header.controlLength()));
            ((InputStream)extraIn).skip(Int$.MODULE$.int2long(Format$.MODULE$.HeaderLength() + header.controlLength() + header.diffLength()));
            CompressorStreamFactory compressor = new CompressorStreamFactory();
            controlIn = compressor.createCompressorInputStream((InputStream)controlIn);
            dataIn = compressor.createCompressorInputStream((InputStream)dataIn);
            extraIn = compressor.createCompressorInputStream((InputStream)extraIn);
            int newPointer = 0;
            int oldPointer = 0;
            byte[] output = new byte[header.outputLength()];
            int outputLength = header.outputLength();
            while (newPointer < outputLength) {
                Format.Block control = Offset$.MODULE$.readBlock(controlIn);
                this.read(dataIn, output, newPointer, control.diffLength());
                for (int i = 0; i < control.diffLength(); ++i) {
                    if (oldPointer + i < 0 || oldPointer + i >= old.length) continue;
                    output[newPointer + i] = (byte)(output[newPointer + i] + old[oldPointer + i]);
                }
                oldPointer += control.diffLength();
                this.read(extraIn, output, newPointer += control.diffLength(), control.extraLength());
                newPointer += control.extraLength();
                oldPointer += control.seekLength();
            }
            out.write(output);
        }
        finally {
            ((InputStream)controlIn).close();
            ((InputStream)dataIn).close();
            ((InputStream)extraIn).close();
        }
    }

    public void patch(File oldFile, File newFile, File patchFile) {
        FileInputStream headerIn = new FileInputStream(patchFile);
        Format.Header header = Offset$.MODULE$.readHeader(headerIn);
        headerIn.close();
        BufferedInputStream controlIn = new BufferedInputStream(new FileInputStream(patchFile));
        BufferedInputStream dataIn = new BufferedInputStream(new FileInputStream(patchFile));
        BufferedInputStream extraIn = new BufferedInputStream(new FileInputStream(patchFile));
        try {
            ((InputStream)controlIn).skip(Int$.MODULE$.int2long(Format$.MODULE$.HeaderLength()));
            ((InputStream)dataIn).skip(Int$.MODULE$.int2long(Format$.MODULE$.HeaderLength() + header.controlLength()));
            ((InputStream)extraIn).skip(Int$.MODULE$.int2long(Format$.MODULE$.HeaderLength() + header.controlLength() + header.diffLength()));
            CompressorStreamFactory compressor = new CompressorStreamFactory();
            controlIn = compressor.createCompressorInputStream((InputStream)controlIn);
            dataIn = compressor.createCompressorInputStream((InputStream)dataIn);
            extraIn = compressor.createCompressorInputStream((InputStream)extraIn);
            FileInputStream oldStream = new FileInputStream(oldFile);
            byte[] old = new byte[(int)oldFile.length()];
            oldStream.read(old);
            oldStream.close();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newFile));
            int newPointer = 0;
            int oldPointer = 0;
            int outputLength = header.outputLength();
            while (newPointer < outputLength) {
                Format.Block control = Offset$.MODULE$.readBlock(controlIn);
                int diffLength = control.diffLength();
                int extraLength = control.extraLength();
                byte[] output = new byte[diffLength + extraLength];
                this.read(dataIn, output, 0, diffLength);
                for (int i = 0; i < diffLength; ++i) {
                    if (oldPointer + i < 0 || oldPointer + i >= old.length) continue;
                    output[i] = (byte)(output[i] + old[oldPointer + i]);
                }
                newPointer += diffLength;
                oldPointer += diffLength;
                this.read(extraIn, output, diffLength, extraLength);
                out.write(output);
                newPointer += extraLength;
                oldPointer += control.seekLength();
            }
            out.close();
        }
        finally {
            ((InputStream)controlIn).close();
            ((InputStream)dataIn).close();
            ((InputStream)extraIn).close();
        }
    }

    private void read(InputStream in, byte[] dest, int off, int len) {
        if (len == 0) {
            return;
        }
        int read = in.read(dest, off, len);
        if (read < len) {
            throw new IOException("Corrupt patch bytes expected = " + len + " bytes read = " + read);
        }
    }

    private int[] sort(byte[] input) {
        int[] I = new int[input.length + 1];
        int[] V = new int[input.length + 1];
        SuffixSort$.MODULE$.qsufsort(I, V, input);
        return I;
    }
}

