/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.file.diff.bsdiff;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.beangle.commons.file.diff.bsdiff.Format;
import org.beangle.commons.file.diff.bsdiff.Format$;
import org.beangle.commons.file.diff.bsdiff.Format$Block$;
import org.beangle.commons.file.diff.bsdiff.Format$Header$;
import scala.runtime.ModuleSerializationProxy;

public final class Offset$
implements Serializable {
    private static final int OFFSET_SIZE;
    public static final Offset$ MODULE$;

    private Offset$() {
    }

    static {
        MODULE$ = new Offset$();
        OFFSET_SIZE = 8;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Offset$.class);
    }

    public int OFFSET_SIZE() {
        return OFFSET_SIZE;
    }

    public int readOffset(InputStream in) {
        byte[] buf = new byte[this.OFFSET_SIZE()];
        int bytesRead = in.read(buf);
        if (bytesRead < this.OFFSET_SIZE()) {
            throw new IOException("Could not read offset.");
        }
        int y = 0;
        y = buf[7] & 0x7F;
        y *= 256;
        y += buf[6] & 0xFF;
        y *= 256;
        y += buf[5] & 0xFF;
        y *= 256;
        y += buf[4] & 0xFF;
        y *= 256;
        y += buf[3] & 0xFF;
        y *= 256;
        y += buf[2] & 0xFF;
        y *= 256;
        y += buf[1] & 0xFF;
        y *= 256;
        if ((y += buf[0] & 0xFF) < 0) {
            throw new IOException("Integer overflow: 64-bit offsets not supported.");
        }
        if ((buf[7] & 0x80) != 0) {
            y = -y;
        }
        return y;
    }

    public void writeOffset(int value2, OutputStream out) {
        byte[] buf = new byte[this.OFFSET_SIZE()];
        int y = 0;
        if (value2 < 0) {
            y = -value2;
            buf[7] = (byte)(buf[7] | 0x80);
        } else {
            y = value2;
        }
        buf[0] = (byte)(buf[0] | y % 256);
        y -= buf[0] & 0xFF;
        buf[1] = (byte)(buf[1] | (y /= 256) % 256);
        y -= buf[1] & 0xFF;
        buf[2] = (byte)(buf[2] | (y /= 256) % 256);
        y -= buf[2] & 0xFF;
        buf[3] = (byte)(buf[3] | (y /= 256) % 256);
        y -= buf[3] & 0xFF;
        buf[4] = (byte)(buf[4] | (y /= 256) % 256);
        y -= buf[4] & 0xFF;
        buf[5] = (byte)(buf[5] | (y /= 256) % 256);
        y -= buf[5] & 0xFF;
        buf[6] = (byte)(buf[6] | (y /= 256) % 256);
        y -= buf[6] & 0xFF;
        buf[7] = (byte)(buf[7] | (y /= 256) % 256);
        out.write(buf);
    }

    public void writeBlock(Format.Block b, OutputStream out) {
        this.writeOffset(b.diffLength(), out);
        this.writeOffset(b.extraLength(), out);
        this.writeOffset(b.seekLength(), out);
    }

    public Format.Block readBlock(InputStream in) {
        return Format$Block$.MODULE$.apply(this.readOffset(in), this.readOffset(in), this.readOffset(in));
    }

    public void writeHeader(Format.Header h, OutputStream out) {
        out.write(Format$.MODULE$.HeaderMagic().getBytes());
        this.writeOffset(h.controlLength(), out);
        this.writeOffset(h.diffLength(), out);
        this.writeOffset(h.outputLength(), out);
    }

    public Format.Header readHeader(InputStream in) {
        DataInputStream headerIn = new DataInputStream(in);
        byte[] buf = new byte[8];
        headerIn.read(buf);
        String magic = new String(buf);
        if (!"BSDIFF40".equals(magic)) {
            throw new RuntimeException("Header missing magic number");
        }
        return Format$Header$.MODULE$.apply(this.readOffset(headerIn), this.readOffset(headerIn), this.readOffset(headerIn));
    }
}

