/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.file.text;

import org.beangle.commons.collection.Collections$;
import org.beangle.commons.file.text.DefaultFormatter;
import org.beangle.commons.file.text.Formatter;
import org.beangle.commons.file.text.Formatter$;
import org.beangle.commons.file.text.LineProcessor;
import org.beangle.commons.file.text.Tab2Space;
import org.beangle.commons.file.text.TrimTrailingWhiteSpace$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.runtime.Scala3RunTime$;

public class FormatterBuilder {
    private int tablength = 2;
    private String eof = Formatter$.MODULE$.LF();
    private boolean tab2space;
    private boolean trimTrailingWhiteSpace;
    private boolean fixLast;

    public int tablength() {
        return this.tablength;
    }

    public void tablength_$eq(int x$1) {
        this.tablength = x$1;
    }

    public String eof() {
        return this.eof;
    }

    public void eof_$eq(String x$1) {
        this.eof = x$1;
    }

    public FormatterBuilder enableTrimTrailingWhiteSpace() {
        this.trimTrailingWhiteSpace = true;
        return this;
    }

    public FormatterBuilder disableTrimTrailingWhiteSpace() {
        this.trimTrailingWhiteSpace = false;
        return this;
    }

    public FormatterBuilder enableTab2space(int tablength) {
        if (1 > tablength || tablength > 8) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"tab length should in [1,8]");
        }
        this.tablength_$eq(tablength);
        this.tab2space = true;
        return this;
    }

    public FormatterBuilder disableTab2space() {
        this.tab2space = false;
        return this;
    }

    public FormatterBuilder insertFinalNewline() {
        this.fixLast = true;
        return this;
    }

    public FormatterBuilder fixcrlf(String eof) {
        String string = eof;
        String string2 = Formatter$.MODULE$.LF();
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = eof;
            String string4 = Formatter$.MODULE$.CRLF();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
        }
        this.eof_$eq(eof);
        return this;
    }

    public Formatter build() {
        Buffer processors = Collections$.MODULE$.newBuffer();
        if (this.tab2space) {
            processors.$plus$eq((Object)new Tab2Space(this.tablength()));
        }
        if (this.trimTrailingWhiteSpace) {
            processors.$plus$eq((Object)TrimTrailingWhiteSpace$.MODULE$);
        }
        return new DefaultFormatter(this.eof(), (List<LineProcessor>)processors.toList(), this.fixLast);
    }
}

