/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.file.watch;

import com.swoval.files.FileTreeViews;
import com.swoval.files.PathWatcher;
import com.swoval.files.PathWatchers;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.file.watch.FileWatcher$;
import org.beangle.commons.file.watch.FileWatcher$WatcherPath$;
import org.beangle.commons.regex.AntPathPattern;
import scala.Function1;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class FileWatcher
implements AutoCloseable {
    private final PathWatcher watcher = PathWatchers.get((boolean)true);

    public static Builder newBuilder() {
        return FileWatcher$.MODULE$.newBuilder();
    }

    public FileWatcher(Iterable<WatcherPath> paths, Observer o) {
        paths.foreach((Function1 & Serializable)path -> this.watcher().register(path.path(), Integer.MAX_VALUE));
        this.watcher().addObserver((FileTreeViews.Observer)new Reply(o, paths));
    }

    public PathWatcher<PathWatchers.Event> watcher() {
        return this.watcher;
    }

    @Override
    public void close() {
        this.watcher().close();
    }

    public static class Builder {
        private final Buffer<WatcherPath> paths = Collections$.MODULE$.newBuffer();

        public Builder add(Path path, Seq<AntPathPattern> patterns) {
            this.paths.addOne((Object)FileWatcher$WatcherPath$.MODULE$.apply(path, patterns));
            return this;
        }

        public Builder add(String path, Seq<String> patterns) {
            this.paths.addOne((Object)FileWatcher$WatcherPath$.MODULE$.apply(Paths.get(path, new String[0]), (Seq<AntPathPattern>)((Seq)patterns.map(FileWatcher$::org$beangle$commons$file$watch$FileWatcher$Builder$$_$add$$anonfun$1))));
            return this;
        }

        public FileWatcher build(Observer o) {
            return new FileWatcher((Iterable<WatcherPath>)this.paths, o);
        }
    }

    @FunctionalInterface
    public static interface Observer {
        public void onChange(String var1, Path var2);
    }

    public static class Reply
    implements FileTreeViews.Observer<PathWatchers.Event> {
        private final Observer o;
        private final Iterable<WatcherPath> paths;
        private final boolean hasFilter;

        public Reply(Observer o, Iterable<WatcherPath> paths) {
            this.o = o;
            this.paths = paths;
            this.hasFilter = paths.exists((Function1 & Serializable)_$1 -> _$1.patterns().nonEmpty());
        }

        public boolean hasFilter() {
            return this.hasFilter;
        }

        public void onError(Throwable t) {
        }

        public void onNext(PathWatchers.Event e) {
            block8: {
                block5: {
                    PathWatchers.Event$.Kind kind;
                    PathWatchers.Event$.Kind kind2;
                    block7: {
                        PathWatchers.Event$.Kind kind3;
                        block6: {
                            PathWatchers.Event$.Kind kind4;
                            PathWatchers.Event$.Kind kind5;
                            block4: {
                                kind3 = e.getKind();
                                kind5 = PathWatchers.Event$.Kind.Error;
                                kind4 = kind3;
                                if (kind5 != null) break block4;
                                if (kind4 == null) break block5;
                                break block6;
                            }
                            if (kind5.equals(kind4)) break block5;
                        }
                        kind2 = PathWatchers.Event$.Kind.Overflow;
                        kind = kind3;
                        if (kind2 != null) break block7;
                        if (kind == null) break block5;
                        break block8;
                    }
                    if (!kind2.equals(kind)) break block8;
                }
                return;
            }
            Path path = e.getTypedPath().getPath();
            if (this.hasFilter()) {
                this.paths.find(arg_0 -> FileWatcher$.org$beangle$commons$file$watch$FileWatcher$Reply$$_$onNext$$anonfun$1(path, arg_0)).foreach((Function1)(JProcedure1 & Serializable)wp -> {
                    if (wp.patterns().isEmpty() || wp.patterns().exists(arg_0 -> FileWatcher$.org$beangle$commons$file$watch$FileWatcher$Reply$$_$onNext$$anonfun$2$$anonfun$1(path, arg_0))) {
                        this.o.onChange(e.getKind().toString(), path);
                        return;
                    }
                });
                return;
            }
            this.o.onChange(e.getKind().toString(), path);
        }
    }

    public static class WatcherPath
    implements Product,
    Serializable {
        private final Path path;
        private final Seq patterns;

        public static WatcherPath apply(Path path, Seq<AntPathPattern> seq) {
            return FileWatcher$WatcherPath$.MODULE$.apply(path, seq);
        }

        public static WatcherPath fromProduct(Product product) {
            return FileWatcher$WatcherPath$.MODULE$.fromProduct(product);
        }

        public static WatcherPath unapplySeq(WatcherPath watcherPath) {
            return FileWatcher$WatcherPath$.MODULE$.unapplySeq(watcherPath);
        }

        public WatcherPath(Path path, Seq<AntPathPattern> patterns) {
            this.path = path;
            this.patterns = patterns;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WatcherPath)) return false;
            WatcherPath watcherPath = (WatcherPath)object;
            Path path = this.path();
            Path path2 = watcherPath.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            Seq<AntPathPattern> seq = this.patterns();
            Seq<AntPathPattern> seq2 = watcherPath.patterns();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!watcherPath.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WatcherPath;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "WatcherPath";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            if (1 == n2) {
                return "patterns";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Path path() {
            return this.path;
        }

        public Seq<AntPathPattern> patterns() {
            return this.patterns;
        }

        public Path _1() {
            return this.path();
        }

        public Seq<AntPathPattern> _2() {
            return this.patterns();
        }
    }
}

