/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.file.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.beangle.commons.io.Dirs$;
import org.beangle.commons.io.Files$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Strings$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class Zipper$
implements Serializable {
    public static final Zipper$ MODULE$ = new Zipper$();

    private Zipper$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Zipper$.class);
    }

    public void unzip(File zipFile, File folder) {
        String outputFolder = folder.getAbsolutePath();
        byte[] buffer = new byte[1024];
        if (!folder.exists()) {
            folder.mkdirs();
        }
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            String fileName = ze.getName();
            File newFile = new File(outputFolder + File.separator + fileName);
            if (ze.isDirectory()) {
                v0 = BoxesRunTime.boxToBoolean((boolean)newFile.mkdirs());
            } else {
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                int len = zis.read(buffer);
                while (len > 0) {
                    fos.write(buffer, 0, len);
                    len = zis.read(buffer);
                }
                fos.close();
                v0 = BoxedUnit.UNIT;
            }
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    public void zip(File dir, File zip, String encoding) {
        if (!dir.exists()) {
            Predef$.MODULE$.println((Object)(dir.getAbsolutePath() + " does not exists,zip process aborted."));
            return;
        }
        if (zip.exists()) {
            zip.delete();
        }
        FileOutputStream fos = new FileOutputStream(zip);
        ZipArchiveOutputStream zos = (ZipArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)fos);
        if (Strings$.MODULE$.isNotEmpty(encoding)) {
            zos.setEncoding(encoding);
        }
        Dirs$.MODULE$.on(dir).ls().foreach((Function1)(JProcedure1 & Serializable)f -> MODULE$.addFile(dir, new File(dir.getAbsolutePath() + Files$.MODULE$.$div() + f), zos));
        zos.close();
    }

    public String zip$default$3() {
        return "utf-8";
    }

    public void zip(File root, Seq<File> files, File zip, String encoding) {
        if (zip.exists()) {
            zip.delete();
        }
        FileOutputStream fos = new FileOutputStream(zip);
        ZipArchiveOutputStream zos = (ZipArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)fos);
        if (Strings$.MODULE$.isNotEmpty(encoding)) {
            zos.setEncoding(encoding);
        }
        files.foreach((Function1)(JProcedure1 & Serializable)f -> MODULE$.addFile(root, (File)f, zos));
        zos.close();
    }

    private void addFile(File root, File dir, ZipArchiveOutputStream zos) {
        if (dir.isDirectory()) {
            Dirs$.MODULE$.on(dir).ls().foreach((Function1)(JProcedure1 & Serializable)a -> {
                File currentFile = new File(dir.getAbsolutePath() + Files$.MODULE$.$div() + a);
                Object entryName = root.toURI().relativize(currentFile.toURI()).getPath();
                if (currentFile.isDirectory()) {
                    if (!((String)entryName).endsWith("/")) {
                        entryName = (String)entryName + "/";
                    }
                    ZipArchiveEntry entry = new ZipArchiveEntry((String)entryName);
                    zos.putArchiveEntry(entry);
                    MODULE$.addFile(root, currentFile, zos);
                    return;
                }
                MODULE$.addElement(root, currentFile, zos);
            });
            return;
        }
        this.addElement(root, dir, zos);
    }

    private void addElement(File root, File file, ZipArchiveOutputStream zos) {
        String entryName = root.toURI().relativize(file.toURI()).getPath();
        ZipArchiveEntry entry = new ZipArchiveEntry(entryName);
        zos.putArchiveEntry(entry);
        FileInputStream fis = new FileInputStream(file);
        IOs$.MODULE$.copy(fis, (OutputStream)zos);
        zos.closeArchiveEntry();
    }
}

