/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.io;

import java.io.Writer;
import org.beangle.commons.io.BufferedWriter$;

public class BufferedWriter
extends Writer {
    private final Writer out;
    private char[] buffer;
    private int pointer;

    public static int $lessinit$greater$default$2() {
        return BufferedWriter$.MODULE$.$lessinit$greater$default$2();
    }

    public BufferedWriter(Writer out, int bufferSize) {
        this.out = out;
        this.buffer = new char[bufferSize];
    }

    @Override
    public void write(int c) {
        if (this.pointer + 1 >= this.buffer.length) {
            this.flushBuffer();
        }
        this.buffer[this.pointer] = (char)c;
        ++this.pointer;
    }

    private void flushBuffer() {
        if (this.pointer == 0) {
            return;
        }
        this.out.write(this.buffer, 0, this.pointer);
        this.pointer = 0;
    }

    @Override
    public void write(char[] c, int off, int len) {
        if (this.pointer + len >= this.buffer.length) {
            this.flushBuffer();
            if (len > this.buffer.length) {
                this.out.write(c, off, len);
                return;
            }
        }
        System.arraycopy(c, 0, this.buffer, this.pointer, len);
        this.pointer += len;
    }

    @Override
    public void flush() {
        this.flushBuffer();
        this.out.flush();
    }

    @Override
    public void close() {
        this.flushBuffer();
        this.out.close();
    }
}

