/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.io.StringBuilderWriter;
import org.beangle.commons.lang.Charsets$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.SystemInfo$;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Files$
implements Serializable {
    private static final int copyBufferSize;
    private static final char[] reservedChars;
    private static final String $div;
    public static final Files$ MODULE$;

    private Files$() {
    }

    static {
        MODULE$ = new Files$();
        copyBufferSize = 0x1E00000;
        reservedChars = new char[]{'/', '\\', ':', '*', '?', '\"', '>', '<', '|', '\t', '\n'};
        $div = File.separator;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Files$.class);
    }

    public String $div() {
        return $div;
    }

    private String fileName(String name) {
        String string = this.$div();
        String string2 = "\\";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Strings$.MODULE$.replace(name, "/", "\\");
        }
        return Strings$.MODULE$.replace(name, "\\", "/");
    }

    public String purify(String name) {
        ObjectRef result = ObjectRef.create((Object)name);
        Object object = Predef$.MODULE$.charArrayOps(reservedChars);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)v1 -> {
            result.elem = ((String)result.elem).replace(BoxesRunTime.unboxToChar((Object)v1), ' ');
            return BoxedUnit.UNIT;
        });
        return (String)result.elem;
    }

    public File forName(String name) {
        return new File(this.expandTilde(name)).getAbsoluteFile();
    }

    public File forName(String pwd, String filePath) {
        String path = this.expandTilde(filePath);
        String string = this.$div();
        String string2 = "\\";
        if (!(string != null ? !string.equals(string2) : string2 != null) && path.contains(":")) {
            return new File(path);
        }
        String string3 = this.$div();
        String string4 = "/";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null) && path.charAt(0) == '/') {
            return new File(path);
        }
        return new File(pwd + this.$div() + path);
    }

    public String expandTilde(String path) {
        String p = this.fileName(path);
        if (p.startsWith("~" + this.$div())) {
            return SystemInfo$.MODULE$.user().home() + p.substring(1);
        }
        if (p.startsWith("~+")) {
            return SystemInfo$.MODULE$.user().dir() + p.substring(2);
        }
        return p;
    }

    public Writer stringWriter(File file, Charset charset) {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
    }

    public Charset stringWriter$default$2() {
        return Charsets$.MODULE$.UTF_8();
    }

    public String readString(File file, Charset charset) {
        String string;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            StringBuilderWriter sw = new StringBuilderWriter(16);
            IOs$.MODULE$.copy(new InputStreamReader((InputStream)in, charset), sw);
            string = sw.toString();
        }
        catch (Throwable throwable) {
            IOs$.MODULE$.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{in}));
            throw throwable;
        }
        IOs$.MODULE$.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{in}));
        return string;
    }

    public Charset readString$default$2() {
        return Charsets$.MODULE$.UTF_8();
    }

    public void writeString(File file, String data, Charset charset) {
        FileOutputStream out = null;
        try {
            out = this.writeOpen(file, this.writeOpen$default$2());
            IOs$.MODULE$.write(data, out, charset);
            ((OutputStream)out).close();
        }
        catch (Throwable throwable) {
            IOs$.MODULE$.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{out}));
            throw throwable;
        }
        IOs$.MODULE$.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{out}));
    }

    public Charset writeString$default$3() {
        return Charsets$.MODULE$.UTF_8();
    }

    public void touch(File file) {
        boolean success;
        if (!file.exists()) {
            IOs$.MODULE$.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{this.writeOpen(file, this.writeOpen$default$2())}));
        }
        if (!(success = file.setLastModified(System.currentTimeMillis()))) {
            throw new IOException("Unable to set the last modification time for " + file);
        }
    }

    public FileOutputStream writeOpen(File file, boolean append) {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }

    public boolean writeOpen$default$2() {
        return false;
    }

    public List<String> readLines(File file, Charset charset) {
        List<String> list;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            list = charset == null ? IOs$.MODULE$.readLines(new InputStreamReader(in)) : IOs$.MODULE$.readLines(new InputStreamReader((InputStream)in, charset));
        }
        catch (Throwable throwable) {
            IOs$.MODULE$.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{in}));
            throw throwable;
        }
        IOs$.MODULE$.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{in}));
        return list;
    }

    public Charset readLines$default$2() {
        return Charsets$.MODULE$.UTF_8();
    }

    public void copy(File src, File dest) throws IOException {
        Predef$.MODULE$.require(src != null);
        Predef$.MODULE$.require(dest != null);
        if (!src.exists()) {
            throw new FileNotFoundException("Source '" + src + "' does not exist");
        }
        if (src.isDirectory()) {
            throw new IOException("Source '" + src + "' exists but is a directory");
        }
        String string = src.getCanonicalPath();
        String string2 = dest.getCanonicalPath();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new IOException("Source '" + src + "' and destination '" + dest + "' are the same");
        }
        File parentFile = dest.getParentFile();
        if (parentFile != null && !parentFile.mkdirs() && !parentFile.isDirectory()) {
            throw new IOException("Destination '" + parentFile + "' directory cannot be created");
        }
        if (dest.exists()) {
            if (dest.isDirectory()) {
                throw new IOException("Destination '" + dest + "' exists but is a directory");
            }
            if (!dest.canWrite()) {
                throw new IOException("Destination '" + dest + "' exists but is read-only");
            }
        }
        this.doCopy(src, dest, true);
    }

    private void doCopy(File srcFile, File destFile, boolean preserveFileDate) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel input = null;
        FileChannel output = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            input = fis.getChannel();
            output = fos.getChannel();
            long size = input.size();
            long count = 0L;
            for (long pos = 0L; pos < size; pos += output.transferFrom(input, pos, count)) {
                count = size - pos > (long)copyBufferSize ? Int$.MODULE$.int2long(copyBufferSize) : size - pos;
            }
        }
        catch (Throwable throwable) {
            IOs$.MODULE$.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{output, fos, input, fis}));
            throw throwable;
        }
        IOs$.MODULE$.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{output, fos, input, fis}));
        if (srcFile.length() != destFile.length()) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
        }
        if (preserveFileDate) {
            destFile.setLastModified(srcFile.lastModified());
            return;
        }
    }

    public void setReadOnly(File file) {
        if (file.exists() && file.canWrite()) {
            this.travel(file, (Function1<File, BoxedUnit>)(JProcedure1 & Serializable)x -> x.setReadOnly());
            return;
        }
    }

    public void setWriteable(File file) {
        if (file.exists() && !Files.isWritable(file.toPath())) {
            this.travel(file, (Function1<File, BoxedUnit>)(JProcedure1 & Serializable)x -> x.setWritable(true));
            return;
        }
    }

    public void setExecutable(File file) {
        if (file.exists() && !Files.isExecutable(file.toPath())) {
            this.travel(file, (Function1<File, BoxedUnit>)(JProcedure1 & Serializable)x -> x.setExecutable(true));
            return;
        }
    }

    public void travel(File file, Function1<File, BoxedUnit> attributeSet) {
        attributeSet.apply((Object)file);
        if (file.isDirectory() && !file.isHidden() && !Files.isSymbolicLink(file.toPath())) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])file.listFiles());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)child -> MODULE$.travel((File)child, attributeSet));
            return;
        }
    }

    public void remove(File file) {
        if (file.isFile()) {
            file.delete();
        }
        this.travel(file, (Function1<File, BoxedUnit>)(JProcedure1 & Serializable)f -> f.delete());
        file.delete();
    }

    public void clear(File file) {
        if (file.isFile()) {
            file.delete();
        }
        this.travel(file, (Function1<File, BoxedUnit>)(JProcedure1 & Serializable)f -> f.delete());
    }
}

