/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import org.beangle.commons.io.StringBuilderWriter;
import org.beangle.commons.lang.Charsets$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class IOs$
implements Logging,
Serializable {
    private static Logger logger;
    private static final int defaultBufferSize;
    private static final int eof;
    public static final IOs$ MODULE$;

    private IOs$() {
    }

    static {
        MODULE$ = new IOs$();
        Logging.$init$(MODULE$);
        defaultBufferSize = 4096;
        eof = -1;
        Statics.releaseFence();
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IOs$.class);
    }

    public long copy(InputStream input, OutputStream output) {
        byte[] buffer = new byte[defaultBufferSize];
        int count = 0;
        int n = input.read(buffer);
        while (eof != n) {
            output.write(buffer, 0, n);
            count += n;
            n = input.read(buffer);
        }
        this.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input}));
        return Int$.MODULE$.int2long(count);
    }

    public byte[] readBytes(InputStream input) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.copy(input, baos);
        return baos.toByteArray();
    }

    public void write(String data, OutputStream output, Charset charset) {
        if (data != null) {
            if (charset == null) {
                output.write(data.getBytes());
                return;
            }
            output.write(data.getBytes(charset));
            return;
        }
    }

    public Charset write$default$3() {
        return null;
    }

    public long copy(Reader input, Writer output) {
        char[] buffer = new char[defaultBufferSize];
        int count = 0;
        int n = input.read(buffer);
        while (eof != n) {
            output.write(buffer, 0, n);
            count += n;
            n = input.read(buffer);
        }
        this.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input}));
        return Int$.MODULE$.int2long(count);
    }

    public List<String> readLines(Reader input) {
        BufferedReader reader = this.toBufferedReader(input);
        ListBuffer list = new ListBuffer();
        String line = reader.readLine();
        while (line != null) {
            list.$plus$eq((Object)line);
            line = reader.readLine();
        }
        this.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input}));
        return list.toList();
    }

    public String readString(InputStream input, Charset charset) {
        String string;
        if (input == null) {
            return "";
        }
        try {
            StringBuilderWriter sw = new StringBuilderWriter(16);
            this.copy(new InputStreamReader(input, charset), sw);
            string = sw.toString();
        }
        catch (Throwable throwable) {
            this.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input}));
            throw throwable;
        }
        this.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input}));
        return string;
    }

    public Charset readString$default$2() {
        return Charsets$.MODULE$.UTF_8();
    }

    public Map<String, String> readProperties(URL url) {
        Map map;
        if (url == null) {
            return Predef$.MODULE$.Map().empty();
        }
        try {
            map = this.readProperties(url.openStream(), this.readProperties$default$2());
        }
        catch (Exception e) {
            Logger$.MODULE$.info$extension(this.logger(), (Function0<String>)((Function0 & Serializable)() -> IOs$.readProperties$$anonfun$1(url, e)));
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public Map<String, String> readProperties(InputStream input, Charset charset) {
        if (input == null) {
            return Predef$.MODULE$.Map().empty();
        }
        HashMap texts = new HashMap();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(input, charset));
        String line = reader.readLine();
        while (line != null) {
            int index = line.indexOf(61);
            if (index > 0) {
                texts.put((Object)line.substring(0, index).trim(), (Object)line.substring(index + 1).trim());
            }
            line = reader.readLine();
        }
        this.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input}));
        return texts.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Charset readProperties$default$2() {
        return Charsets$.MODULE$.UTF_8();
    }

    public Map<String, String> readJavaProperties(URL url) {
        Map map;
        if (url == null) {
            return Predef$.MODULE$.Map().empty();
        }
        try {
            map = this.readJavaProperties(url.openStream());
        }
        catch (Exception e) {
            Logger$.MODULE$.info$extension(this.logger(), (Function0<String>)((Function0 & Serializable)() -> IOs$.readJavaProperties$$anonfun$1(url, e)));
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public Map<String, String> readJavaProperties(InputStream input) {
        if (input == null) {
            return Predef$.MODULE$.Map().empty();
        }
        Properties properties = new Properties();
        properties.load(input);
        this.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input}));
        return CollectionConverters$.MODULE$.PropertiesHasAsScala(properties).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public List<String> readLines(InputStream input, Charset charset) {
        return this.readLines(new InputStreamReader(input, charset));
    }

    public Charset readLines$default$2() {
        return Charsets$.MODULE$.UTF_8();
    }

    public void close(Seq<AutoCloseable> objs) {
        objs.foreach((Function1)(JProcedure1 & Serializable)obj -> {
            try {
                if (obj != null) {
                    obj.close();
                }
            }
            catch (Exception exception) {}
        });
    }

    public <T extends AutoCloseable, R> R using(T res, Function1<T, R> func) {
        Object object;
        try {
            object = func.apply(res);
        }
        finally {
            if (res != null) {
                res.close();
            }
        }
        return (R)object;
    }

    private BufferedReader toBufferedReader(Reader reader) {
        Reader reader2 = reader;
        if (reader2 instanceof BufferedReader) {
            BufferedReader reader1 = (BufferedReader)reader2;
            return reader1;
        }
        return new BufferedReader(reader);
    }

    private static final String readProperties$$anonfun$1(URL url$1, Exception e$1) {
        return "load " + url$1 + " error:" + e$1.getMessage();
    }

    private static final String readJavaProperties$$anonfun$1(URL url$2, Exception e$2) {
        return "load " + url$2 + " error:" + e$2.getMessage();
    }
}

