/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.jndi;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.beangle.commons.bean.Factory;
import org.beangle.commons.jndi.JndiObjectFactory$;

public class JndiObjectFactory<T>
implements Factory<T> {
    private final String jndiName;
    private boolean resourceRef;
    private Properties environment;

    public static String containerPrefix() {
        return JndiObjectFactory$.MODULE$.containerPrefix();
    }

    public JndiObjectFactory(String jndiName) {
        this.jndiName = jndiName;
        this.resourceRef = true;
    }

    public String jndiName() {
        return this.jndiName;
    }

    public boolean resourceRef() {
        return this.resourceRef;
    }

    public void resourceRef_$eq(boolean x$1) {
        this.resourceRef = x$1;
    }

    public Properties environment() {
        return this.environment;
    }

    public void environment_$eq(Properties x$1) {
        this.environment = x$1;
    }

    @Override
    public T result() {
        InitialContext ctx = new InitialContext();
        Object located = ctx.lookup(this.convertJndiName(this.jndiName()));
        if (located == null) {
            throw new NameNotFoundException("JNDI object with [" + this.jndiName() + "] not found: JNDI implementation returned null");
        }
        return (T)located;
    }

    public String convertJndiName(String jndiName) {
        if (this.resourceRef() && !jndiName.startsWith(JndiObjectFactory$.MODULE$.containerPrefix()) && jndiName.indexOf(58) == -1) {
            return JndiObjectFactory$.MODULE$.containerPrefix() + jndiName;
        }
        return jndiName;
    }
}

