/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.json;

import java.io.Serializable;
import org.beangle.commons.json.JsonObject;
import org.beangle.commons.json.JsonObject$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;

public class JsonArray
implements Seq<Object> {
    private final ArrayBuffer values;

    public JsonArray() {
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        Iterable.$init$((Iterable)this);
        PartialFunction.$init$((PartialFunction)this);
        SeqOps.$init$((SeqOps)this);
        Seq.$init$((Seq)this);
        this.values = new ArrayBuffer();
    }

    public <B> Seq<B> scala$collection$SeqOps$$super$concat(IterableOnce<B> suffix) {
        return (Seq)IterableOps.concat$((IterableOps)this, suffix);
    }

    public int scala$collection$SeqOps$$super$sizeCompare(int otherSize) {
        return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
    }

    public int scala$collection$SeqOps$$super$sizeCompare(Iterable<?> that) {
        return IterableOps.sizeCompare$((IterableOps)this, that);
    }

    public JsonArray(Iterable<Object> v) {
        this();
        this.values().addAll(v);
    }

    private ArrayBuffer<Object> values() {
        return this.values;
    }

    public void add(Object value2) {
        this.values().addOne(value2);
    }

    public Option<Object> get(int i) {
        if (i >= 0 && i < this.values().size()) {
            return Some$.MODULE$.apply(this.values().apply(i));
        }
        return None$.MODULE$;
    }

    public Object get(String[] paths) {
        int i = 0;
        Object o = this;
        while (o != null && i < paths.length) {
            String part = paths[i];
            ++i;
            Object object = o;
            if (object instanceof JsonObject) {
                JsonObject jo = (JsonObject)object;
                o = jo.get(part).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                continue;
            }
            if (object instanceof JsonArray) {
                JsonArray ja = object;
                int index = -1;
                if (part.startsWith("[")) {
                    index = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(part.substring(1, part.length() - 1)));
                } else if (Numbers$.MODULE$.isDigits(part)) {
                    index = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(part));
                }
                if (index > -1) {
                    o = ja.get(index).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    continue;
                }
                o = new JsonArray((Iterable<Object>)((Iterable)((StrictOptimizedIterableOps)ja.values().map((Function1 & Serializable)x$1 -> {
                    Object object = x$1;
                    if (object instanceof JsonObject) {
                        JsonObject j = (JsonObject)object;
                        return j.get(part).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    }
                    if (object instanceof JsonArray) {
                        JsonArray a = (JsonArray)object;
                        return null;
                    }
                    return null;
                })).filter((Function1 & Serializable)_$1 -> _$1 != null)));
                continue;
            }
            throw new MatchError(object);
        }
        return o;
    }

    public Object query(String path) {
        String[] parts = path.charAt(0) == '/' ? Strings$.MODULE$.split(path, "/") : Strings$.MODULE$.split(path, ".");
        return this.get(parts);
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder("[");
        this.values().foreach((Function1 & Serializable)v -> {
            Object object = v;
            if (object instanceof JsonObject) {
                JsonObject o = (JsonObject)object;
                v0 = sb.append(o.toJson());
            } else if (object instanceof JsonArray) {
                JsonArray a = (JsonArray)object;
                v0 = sb.append(a.toJson());
            } else {
                v0 = sb.append(JsonObject$.MODULE$.toLiteral(v));
            }
            return sb.append(",");
        });
        if (this.values().nonEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.append("]").toString();
    }

    public Iterator<Object> iterator() {
        return this.values().iterator();
    }

    public Object apply(int i) {
        return this.values().apply(i);
    }

    public int length() {
        return this.values().length();
    }

    public String toString() {
        return this.toJson();
    }
}

