/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.json;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.beangle.commons.conversion.string.TemporalConverter$;
import org.beangle.commons.json.JsonArray;
import org.beangle.commons.json.JsonObject$;
import org.beangle.commons.lang.Strings$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class JsonObject
implements Iterable<Tuple2<String, Object>> {
    private Map map;

    public static String toLiteral(Object object) {
        return JsonObject$.MODULE$.toLiteral(object);
    }

    public JsonObject() {
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        Iterable.$init$((Iterable)this);
        this.map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private Map<String, Object> map() {
        return this.map;
    }

    private void map_$eq(Map<String, Object> x$0) {
        this.map = x$0;
    }

    public JsonObject(Iterable<Tuple2<String, Object>> v) {
        this();
        v.foreach((Function1)(JProcedure1 & Serializable)x -> this.add((String)x._1(), x._2()));
    }

    public Map<String, Object> values() {
        return this.map().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<Object> query(String path) {
        String[] parts = path.charAt(0) == '/' ? Strings$.MODULE$.split(path, "/") : Strings$.MODULE$.split(path, ".");
        Object o = this;
        for (int i = 0; o != null && i < parts.length; ++i) {
            String part = parts[i];
            Object object = o;
            if (object == null) {
                o = null;
                continue;
            }
            if (object instanceof JsonObject) {
                JsonObject jo = object;
                o = jo.map().getOrElse((Object)part, JsonObject::query$$anonfun$1);
                continue;
            }
            if (object instanceof JsonArray) {
                JsonArray ja = (JsonArray)object;
                o = ja.get(new String[]{part});
                continue;
            }
            o = null;
        }
        return Option$.MODULE$.apply(o);
    }

    public void add(String key, Object value2) {
        if (value2 == null) {
            this.map_$eq((Map<String, Object>)((Map)this.map().$minus((Object)key)));
            return;
        }
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
        this.map_$eq((Map<String, Object>)((Map)this.map().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, value2))));
    }

    public Option<Object> get(String key) {
        return this.map().get((Object)key);
    }

    public String getString(String key, String defaultValue) {
        Option option = this.map().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            return s.toString();
        }
        return defaultValue;
    }

    public String getString$default$2() {
        return "";
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Option option = this.map().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            Object object = s;
            if (object instanceof Boolean) {
                boolean i = BoxesRunTime.unboxToBoolean((Object)object);
                return i;
            }
            if (object instanceof Number) {
                Number n = (Number)object;
                return n.intValue() > 0;
            }
            Object s2 = object;
            return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(s2.toString()));
        }
        return defaultValue;
    }

    public boolean getBoolean$default$2() {
        return false;
    }

    public int getInt(String key, int defaultValue) {
        Option option = this.map().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            Object object = s;
            if (object instanceof Integer) {
                int i = BoxesRunTime.unboxToInt((Object)object);
                return i;
            }
            if (object instanceof Number) {
                Number n = (Number)object;
                return n.intValue();
            }
            Object s2 = object;
            return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s2.toString()));
        }
        return defaultValue;
    }

    public int getInt$default$2() {
        return 0;
    }

    public long getLong(String key, long defaultValue) {
        Option option = this.map().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            Object object = s;
            if (object instanceof Long) {
                long i = BoxesRunTime.unboxToLong((Object)object);
                return i;
            }
            if (object instanceof Number) {
                Number n = (Number)object;
                return n.longValue();
            }
            Object s2 = object;
            return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s2.toString()));
        }
        return defaultValue;
    }

    public long getLong$default$2() {
        return 0L;
    }

    public double getDouble(String key, double defaultValue) {
        Option option = this.map().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            Object object = s;
            if (object instanceof Number) {
                Number n = (Number)object;
                return n.doubleValue();
            }
            Object s2 = object;
            return StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s2.toString()));
        }
        return defaultValue;
    }

    public double getDouble$default$2() {
        return 0.0;
    }

    public LocalDate getDate(String key, LocalDate defaultValue) {
        Option option = this.map().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            return TemporalConverter$.MODULE$.convert(s.toString(), LocalDate.class);
        }
        return defaultValue;
    }

    public LocalDate getDate$default$2() {
        return null;
    }

    public LocalDateTime getDateTime(String key, LocalDateTime defaultValue) {
        Option option = this.map().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            return TemporalConverter$.MODULE$.convert(s.toString(), LocalDateTime.class);
        }
        return defaultValue;
    }

    public LocalDateTime getDateTime$default$2() {
        return null;
    }

    public Instant getInstant(String key, Instant defaultValue) {
        Option option = this.map().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            return TemporalConverter$.MODULE$.convert(s.toString(), Instant.class);
        }
        return defaultValue;
    }

    public Instant getInstant$default$2() {
        return null;
    }

    public JsonObject getObject(String key, JsonObject defaultValue) {
        Option option = this.map().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            return (JsonObject)s;
        }
        if (defaultValue == null) {
            return new JsonObject();
        }
        return defaultValue;
    }

    public JsonObject getObject$default$2() {
        return null;
    }

    public boolean contains(String key) {
        return this.map().contains((Object)key);
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder("{");
        this.map().foreach((Function1 & Serializable)kv -> {
            Object object = kv._2();
            if (object instanceof JsonObject) {
                JsonObject o = (JsonObject)object;
                v0 = sb.append((String)kv._1()).append(":").append(o.toJson());
            } else if (object instanceof JsonArray) {
                JsonArray a = (JsonArray)object;
                v0 = sb.append((String)kv._1()).append(":").append(a.toJson());
            } else {
                v0 = sb.append((String)kv._1()).append(":").append(JsonObject$.MODULE$.toLiteral(kv._2()));
            }
            return sb.append(",");
        });
        if (this.map().nonEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.append("}").toString();
    }

    public Iterator<Tuple2<String, Object>> iterator() {
        return this.map().iterator();
    }

    public String toString() {
        return this.toJson();
    }

    private static final Object query$$anonfun$1() {
        return null;
    }
}

