/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang;

import java.io.Serializable;
import java.util.Iterator;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Assert$
implements Serializable {
    private static final String NotEmptyCharSeqMsg;
    private static final String IsNullMsg;
    private static final String IsTrueMsg;
    public static final Assert$ MODULE$;

    private Assert$() {
    }

    static {
        MODULE$ = new Assert$();
        NotEmptyCharSeqMsg = "The validated character sequence is empty";
        IsNullMsg = "The validated object is null";
        IsTrueMsg = "The validated expression is false";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Assert$.class);
    }

    public void isTrue(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException(IsTrueMsg);
        }
    }

    public void isTrue(boolean expression, String message, Seq<Object> values) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, values));
        }
    }

    public <T> T notNull(T value2) {
        return this.notNull(value2, IsNullMsg, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[0]));
    }

    public <T> T notNull(T value2, String message, Seq<Object> values) {
        if (value2 == null) {
            throw new NullPointerException(String.format(message, values));
        }
        return value2;
    }

    public <T extends CharSequence> T notEmpty(T chars) {
        if (chars == null) {
            throw new NullPointerException(NotEmptyCharSeqMsg);
        }
        if (chars.length() == 0) {
            throw new IllegalArgumentException(NotEmptyCharSeqMsg);
        }
        return chars;
    }

    public <T extends CharSequence> T notEmpty(T chars, String message, Seq<Object> values) {
        if (chars == null) {
            throw new NullPointerException(String.format(message, values));
        }
        if (chars.length() == 0) {
            throw new IllegalArgumentException(String.format(message, values));
        }
        return chars;
    }

    public <T extends Iterable<?>> T noNullElements(T iterable, String message, Seq<Object> values) {
        this.notNull(iterable);
        int i = 0;
        Iterator<?> it = iterable.iterator();
        while (it.hasNext()) {
            if (it.next() == null) {
                throw new IllegalArgumentException(String.format(message, String.valueOf(i)));
            }
            ++i;
        }
        return iterable;
    }
}

