/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.time.HourMinute;
import org.beangle.commons.lang.time.HourMinute$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;

public final class Dates$
implements Serializable {
    public static final Dates$ MODULE$ = new Dates$();

    private Dates$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Dates$.class);
    }

    public LocalDate today() {
        return LocalDate.now();
    }

    public LocalDateTime now() {
        return LocalDateTime.now();
    }

    public HourMinute toHourMinute(String value2) {
        if (Strings$.MODULE$.isEmpty(value2)) {
            return null;
        }
        return HourMinute$.MODULE$.apply(value2);
    }

    public LocalTime toTime(String value2) {
        if (Strings$.MODULE$.isEmpty(value2)) {
            return null;
        }
        return LocalTime.parse(value2);
    }

    public MonthDay toMonthDay(String value2) {
        if (Strings$.MODULE$.isEmpty(value2)) {
            return null;
        }
        return MonthDay.parse(this.normalizeMonthDay(value2));
    }

    public YearMonth toYearMonth(String value2) {
        if (Strings$.MODULE$.isEmpty(value2)) {
            return null;
        }
        return YearMonth.parse(this.nomalizeYearMonth(value2));
    }

    public LocalDate toDate(String value2) {
        if (Strings$.MODULE$.isEmpty(value2)) {
            return null;
        }
        return LocalDate.parse(this.normalizeDate(value2));
    }

    public LocalDateTime toDateTime(String value2) {
        if (Strings$.MODULE$.isEmpty(value2)) {
            return null;
        }
        return LocalDateTime.parse(this.normalizeDateTime(value2));
    }

    public ZonedDateTime toZonedDateTime(String value2) {
        if (Strings$.MODULE$.isEmpty(value2)) {
            return null;
        }
        return ZonedDateTime.parse(this.normalizeDateTime(value2));
    }

    public OffsetDateTime toOffsetateTime(String value2) {
        if (Strings$.MODULE$.isEmpty(value2)) {
            return null;
        }
        return OffsetDateTime.parse(this.normalizeDateTime(value2));
    }

    public Instant toInstant(String value2) {
        if (Strings$.MODULE$.isEmpty(value2)) {
            return null;
        }
        if (value2.endsWith("Z")) {
            return Instant.parse(value2);
        }
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(value2), '+')) {
            return OffsetDateTime.parse(this.normalizeDateTime(value2)).toInstant();
        }
        String text = this.normalizeDateTime(value2);
        return LocalDateTime.parse(text).atZone(ZoneId.systemDefault()).toInstant();
    }

    public String normalizeDate(String str) {
        int dayIndex;
        String dateStr = str.contains(".") ? Strings$.MODULE$.replace(str, ".", "-") : str;
        if (!(dateStr = Strings$.MODULE$.replace(dateStr, "/", "-")).contains("-")) {
            StringBuilder dateBuf = new StringBuilder(dateStr);
            dateBuf.insert("yyyyMM".length(), '-');
            dateBuf.insert("yyyy".length(), '-');
            return dateBuf.toString();
        }
        if (dateStr.length() >= 10) {
            return dateStr;
        }
        if (dateStr.length() < 8) {
            throw new IllegalArgumentException();
        }
        char[] value2 = dateStr.toCharArray();
        int n = value2[6] == '-' ? 7 : (dayIndex = value2[7] == '-' ? 8 : -1);
        if (dayIndex < 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder(10);
        sb.appendAll(value2, 0, 5);
        StringBuilder stringBuilder = dayIndex - 5 < 3 ? sb.append('0').appendAll(value2, 5, 2) : sb.appendAll(value2, 5, 3);
        StringBuilder stringBuilder2 = value2.length - dayIndex < 2 ? sb.append('0').appendAll(value2, dayIndex, 1) : sb.appendAll(value2, dayIndex, 2);
        return sb.toString();
    }

    public String normalizeDateTime(String value2) {
        String v = Strings$.MODULE$.replace(value2, " ", "T");
        int sepIdx = v.indexOf(84);
        Object hms = null;
        String date = null;
        if (sepIdx == -1) {
            hms = "00:00:00";
            date = v;
        } else {
            hms = v.substring(sepIdx + 1);
            date = v.substring(0, sepIdx);
            int commaCount = Strings$.MODULE$.count((String)hms, ':');
            if (((String)hms).isEmpty()) {
                hms = "00:00:00";
            } else if (commaCount == 0) {
                hms = (String)hms + ":00:00";
            } else if (commaCount == 1) {
                hms = (String)hms + ":00";
            }
        }
        return this.normalizeDate(date) + "T" + (String)hms;
    }

    public String nomalizeYearMonth(String ym) {
        String str = Strings$.MODULE$.replace(ym, ".", "-");
        if (str.contains("-")) {
            String[] parts = this.splitDate(str);
            return parts[0] + "-" + parts[1];
        }
        String[] parts = this.splitDate(str.substring(0, 4) + "-" + str.substring(4));
        return parts[0] + "-" + parts[1];
    }

    public String normalizeMonthDay(String md) {
        String str = Strings$.MODULE$.replace(md, ".", "-");
        if (str.startsWith("--")) {
            str = str.substring(2);
        }
        String[] parts = this.splitDate(str);
        return "--" + parts[0] + "-" + parts[1];
    }

    private String[] splitDate(String str) {
        Object[] parts = Strings$.MODULE$.split(str, "-");
        Object object = Predef$.MODULE$.refArrayOps(parts);
        ArrayOps$.MODULE$.indices$extension(object).foreach((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> Dates$.splitDate$$anonfun$1((String[])parts, arg_0)));
        return parts;
    }

    private static final /* synthetic */ void splitDate$$anonfun$1(String[] parts$1, int i) {
        parts$1[i] = Strings$.MODULE$.leftPad(parts$1[i], 2, '0');
    }
}

