/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.beangle.commons.lang.Strings$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Numbers$
implements Serializable {
    public static final Numbers$ MODULE$ = new Numbers$();

    private Numbers$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Numbers$.class);
    }

    public int toInt(String str, int defaultValue) {
        int n;
        if (Strings$.MODULE$.isEmpty(str)) {
            return defaultValue;
        }
        try {
            n = (int)Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            n = defaultValue;
        }
        return n;
    }

    public int toInt$default$2() {
        return 0;
    }

    public int[] toInt(String[] ids) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])ids);
        return (int[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x -> this.toInt((String)x, this.toInt$default$2()), ClassTag$.MODULE$.apply(Integer.TYPE));
    }

    public short toShort(String str, short defaultValue) {
        short s;
        if (Strings$.MODULE$.isEmpty(str)) {
            return defaultValue;
        }
        try {
            s = Short.parseShort(str);
        }
        catch (NumberFormatException nfe) {
            s = defaultValue;
        }
        return s;
    }

    public short toShort$default$2() {
        return 0;
    }

    public long toLong(String str, long defaultValue) {
        long l;
        if (Strings$.MODULE$.isEmpty(str)) {
            return defaultValue;
        }
        try {
            l = Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            l = defaultValue;
        }
        return l;
    }

    public long toLong$default$2() {
        return 0L;
    }

    public long[] toLong(String[] ids) {
        if (ids == null) {
            return null;
        }
        long[] idsOfLong = new long[ids.length];
        Object object = Predef$.MODULE$.refArrayOps((Object[])ids);
        ArrayOps$.MODULE$.indices$extension(object).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            idsOfLong$1[i] = Long.parseLong(ids[i]);
        });
        return idsOfLong;
    }

    public float toFloat(String str, float defaultValue) {
        float f;
        if (Strings$.MODULE$.isEmpty(str)) {
            return defaultValue;
        }
        try {
            f = Float.parseFloat(str);
        }
        catch (NumberFormatException nfe) {
            f = defaultValue;
        }
        return f;
    }

    public float toFloat$default$2() {
        return 0.0f;
    }

    public double toDouble(String str, double defaultValue) {
        double d;
        if (Strings$.MODULE$.isEmpty(str)) {
            return defaultValue;
        }
        try {
            d = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            d = defaultValue;
        }
        return d;
    }

    public double toDouble$default$2() {
        return 0.0;
    }

    public Integer convert2Int(String str, Integer defaultValue) {
        Integer n;
        if (Strings$.MODULE$.isEmpty(str)) {
            return defaultValue;
        }
        try {
            n = Integer.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            n = defaultValue;
        }
        return n;
    }

    public Integer convert2Int$default$2() {
        return null;
    }

    public Short convert2Short(String str, Short defaultValue) {
        Short s;
        if (Strings$.MODULE$.isEmpty(str)) {
            return defaultValue;
        }
        try {
            s = Short.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            s = defaultValue;
        }
        return s;
    }

    public Short convert2Short$default$2() {
        return null;
    }

    public Long convert2Long(String str, Long defaultValue) {
        Long l;
        if (Strings$.MODULE$.isEmpty(str)) {
            return defaultValue;
        }
        try {
            l = Long.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            l = defaultValue;
        }
        return l;
    }

    public Long convert2Long$default$2() {
        return null;
    }

    public Float convert2Float(String str, Float defaultValue) {
        Float f;
        if (Strings$.MODULE$.isEmpty(str)) {
            return defaultValue;
        }
        try {
            f = Float.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            f = defaultValue;
        }
        return f;
    }

    public Float convert2Float$default$2() {
        return null;
    }

    public Double convert2Double(String str, Double defaultValue) {
        Double d;
        if (Strings$.MODULE$.isEmpty(str)) {
            return defaultValue;
        }
        try {
            d = Double.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            d = defaultValue;
        }
        return d;
    }

    public Double convert2Double$default$2() {
        return null;
    }

    public BigInteger convert2BigInt(String str, BigInteger defaultValue) {
        BigInteger bigInteger;
        if (Strings$.MODULE$.isEmpty(str)) {
            return defaultValue;
        }
        try {
            bigInteger = new BigInteger(str);
        }
        catch (NumberFormatException nfe) {
            bigInteger = defaultValue;
        }
        return bigInteger;
    }

    public BigInteger convert2BigInt$default$2() {
        return null;
    }

    public BigDecimal convert2BigDecimal(String str, BigDecimal defaultValue) {
        BigDecimal bigDecimal;
        if (Strings$.MODULE$.isEmpty(str)) {
            return defaultValue;
        }
        try {
            bigDecimal = new BigDecimal(str);
        }
        catch (NumberFormatException nfe) {
            bigDecimal = defaultValue;
        }
        return bigDecimal;
    }

    public BigDecimal convert2BigDecimal$default$2() {
        return null;
    }

    public boolean isDigits(String str) {
        if (Strings$.MODULE$.isEmpty(str)) {
            return false;
        }
        int start = str.charAt(0) == '-' ? 1 : 0;
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(start), str.length()).forall((Function1)(JFunction1.mcZI.sp & Serializable)i -> Character.isDigit(str.charAt(i)));
    }

    public double round(double n, int scale) {
        BigDecimal b = new BigDecimal(Double.toString(n));
        return b.setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    public double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public double subtract(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public double multiply(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public double divide(double v1, double v2, int scale) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, RoundingMode.HALF_UP).doubleValue();
    }

    public int divide$default$3() {
        return 10;
    }
}

