/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class Processes$
implements Logging,
Serializable {
    private static Logger logger;
    private static final int DefaultWaitSeconds;
    public static final Processes$ MODULE$;

    private Processes$() {
    }

    static {
        MODULE$ = new Processes$();
        Logging.$init$(MODULE$);
        DefaultWaitSeconds = 60;
        Statics.releaseFence();
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Processes$.class);
    }

    public int DefaultWaitSeconds() {
        return DefaultWaitSeconds;
    }

    public Process launch(String program, Seq<String> args) {
        return this.launch(program, args, (Function1<ProcessBuilder, BoxedUnit>)(JProcedure1 & Serializable)_$1 -> _$1.inheritIO());
    }

    public Process launch(String program, Seq<String> args, Function1<ProcessBuilder, BoxedUnit> f) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(program);
        arguments.addAll(CollectionConverters$.MODULE$.SeqHasAsJava(args).asJava());
        ProcessBuilder pb = new ProcessBuilder(new String[0]).command(arguments);
        f.apply((Object)pb);
        return pb.start();
    }

    public boolean isExecutable(String binaryPath) {
        return this.isExecutable(Paths.get(binaryPath, new String[0]));
    }

    public Option<Path> find(String envName, Seq<String> alternatives) {
        String path = System.getenv(envName);
        if (path == null) {
            Path result = null;
            for (int i = 0; result == null && i < alternatives.length(); ++i) {
                String pi = (String)alternatives.apply(i);
                if (!this.isExecutable(pi)) continue;
                result = Paths.get(pi, new String[0]).toAbsolutePath();
            }
            return Option$.MODULE$.apply(result);
        }
        if (this.isExecutable(path)) {
            return Some$.MODULE$.apply((Object)Paths.get(path, new String[0]).toAbsolutePath());
        }
        Logger$.MODULE$.error$extension(this.logger(), (Function0<String>)((Function0 & Serializable)() -> Processes$.find$$anonfun$1(envName, path)));
        return None$.MODULE$;
    }

    public int close(Process process, int waitSeconds) {
        if (process != null && process.isAlive()) {
            process.destroy();
            try {
                if (!process.waitFor(Int$.MODULE$.int2long(waitSeconds), TimeUnit.SECONDS)) {
                    process.destroyForcibly();
                    process.waitFor(Int$.MODULE$.int2long(waitSeconds), TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException e) {
                process.destroyForcibly();
            }
        }
        if (process != null) {
            return process.exitValue();
        }
        return 0;
    }

    public int close$default$2() {
        return this.DefaultWaitSeconds();
    }

    public Option<Matcher> grep(Process process, Pattern pattern, int waitSeconds) {
        Option option;
        CompletableFuture result = new CompletableFuture();
        AtomicReference<String> output = new AtomicReference<String>("");
        Runnable readLine = new Runnable(process, result, pattern, output){
            private final Process process$1;
            private final CompletableFuture result$1;
            private final Pattern pattern$1;
            private final AtomicReference output$1;
            {
                this.process$1 = process$2;
                this.result$1 = result$2;
                this.pattern$1 = pattern$2;
                this.output$1 = output$3;
            }

            public void run() {
                StringBuilder sb = new StringBuilder();
                BufferedReader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new InputStreamReader(this.process$1.getInputStream()));
                        String line = reader.readLine();
                        while (line != null && !this.result$1.isDone()) {
                            Matcher matcher = this.pattern$1.matcher(line);
                            if (matcher.find()) {
                                this.result$1.complete(matcher);
                                sb = null;
                                this.output$1.set(null);
                                line = null;
                                continue;
                            }
                            if (sb.nonEmpty()) {
                                sb.append(System.lineSeparator());
                            }
                            sb.append(line);
                            this.output$1.set(sb.toString());
                            line = reader.readLine();
                        }
                    }
                    catch (Exception e) {
                        if (!this.result$1.isDone()) {
                            this.result$1.completeExceptionally(e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOs$.MODULE$.close((scala.collection.immutable.Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{reader}));
                    throw throwable;
                }
                IOs$.MODULE$.close((scala.collection.immutable.Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{reader}));
            }
        };
        Thread readLineThread = new Thread(readLine);
        readLineThread.setName("read-line-thread");
        readLineThread.start();
        try {
            option = Option$.MODULE$.apply(result.get(Int$.MODULE$.int2long(waitSeconds), TimeUnit.SECONDS));
        }
        catch (TimeoutException e) {
            this.close(readLineThread);
            Logger$.MODULE$.debug$extension(this.logger(), (Function0<String>)((Function0 & Serializable)() -> Processes$.grep$$anonfun$1(output)));
            option = None$.MODULE$;
        }
        catch (Exception e) {
            this.close(readLineThread);
            Logger$.MODULE$.error$extension(this.logger(), (Function0<String>)((Function0 & Serializable)Processes$::grep$$anonfun$2), (Function0<Throwable>)((Function0 & Serializable)() -> Processes$.grep$$anonfun$3(e)));
            option = None$.MODULE$;
        }
        return option;
    }

    private void close(Thread thread) {
        try {
            thread.join(TimeUnit.SECONDS.toMillis(5L));
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean isExecutable(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path) && Files.isExecutable(path);
    }

    private static final String find$$anonfun$1(String envName$1, String path$1) {
        return envName$1 + ":" + path$1 + " is not an executable file.";
    }

    private static final String grep$$anonfun$1(AtomicReference output$2) {
        return "Failed while waiting for starting: Timeout expired! output: " + output$2.get();
    }

    private static final String grep$$anonfun$2() {
        return "Failed while waiting for starting.";
    }

    private static final Throwable grep$$anonfun$3(Exception e$1) {
        return e$1;
    }
}

