/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang;

import java.io.Serializable;
import java.util.Formatter;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Numbers$;
import scala.Char$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Strings$
implements Serializable {
    private static final String DELIMITER;
    private static final String Empty;
    private static final int Index_not_found;
    public static final Strings$ MODULE$;

    private Strings$() {
    }

    static {
        MODULE$ = new Strings$();
        DELIMITER = ",";
        Empty = "";
        Index_not_found = -1;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Strings$.class);
    }

    public String DELIMITER() {
        return DELIMITER;
    }

    public String capitalize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char head = str.charAt(0);
        char upper = Character.toUpperCase(head);
        if (upper == head) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = upper;
        return new String(chars);
    }

    public String concat(Seq<Object> seq) {
        return this.join((Iterable<?>)seq, null);
    }

    public boolean contains(CharSequence seq, CharSequence searchSeq) {
        if (seq == null || searchSeq == null) {
            return false;
        }
        return this.indexOf(seq, searchSeq, 0) >= 0;
    }

    public boolean contains(CharSequence seq, int searchChar) {
        if (this.isEmpty(seq)) {
            return false;
        }
        return this.indexOf(seq, searchChar, 0) >= 0;
    }

    public int count(String host, char charactor) {
        IntRef count = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), host.length()).withFilter((Function1)(JFunction1.mcZI.sp & Serializable)i -> host.charAt(i) == charactor).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> ++count$1.elem);
        return count.elem;
    }

    public int count(String host, String searchStr) {
        int count = 0;
        int startIndex = host.indexOf(searchStr, 0);
        while (startIndex > -1 && startIndex < host.length()) {
            ++count;
            startIndex = host.indexOf(searchStr, startIndex + searchStr.length());
        }
        return count;
    }

    private int indexOf(CharSequence cs, CharSequence searchChar, int start) {
        return cs.toString().indexOf(searchChar.toString(), start);
    }

    private int indexOf(CharSequence cs, int searchChar, int start) {
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar, start);
        }
        return BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(start < 0 ? 0 : start), cs.length()).find((Function1)(JFunction1.mcZI.sp & Serializable)_$1 -> cs.charAt(_$1) == searchChar).getOrElse(Strings$::indexOf$$anonfun$2));
    }

    public String insert(String str, String c, int pos) {
        if (str.length() < pos) {
            return str;
        }
        return str.substring(0, pos - 1) + c + str.substring(pos);
    }

    public String insert(String str, String contnets, int beginAt, int endAt) {
        if (beginAt < 1 || endAt > str.length() || endAt < beginAt) {
            return str;
        }
        return str.substring(0, beginAt - 1) + contnets + str.substring(endAt);
    }

    public String intersectSeq(String first, String second) {
        return this.intersectSeq(first, second, this.DELIMITER());
    }

    public String intersectSeq(String first, String second, String delimiter) {
        if (this.isEmpty(first) || this.isEmpty(second)) {
            return "";
        }
        List rs = Collections$.MODULE$.intersection(Predef$.MODULE$.wrapRefArray((Object[])this.split(first, ',')).toList(), Predef$.MODULE$.wrapRefArray((Object[])this.split(second, ',')).toList());
        StringBuilder buf = new StringBuilder();
        rs.foreach((Function1 & Serializable)ele -> buf.append(delimiter).append(ele));
        if (buf.length() > 0) {
            buf.append(delimiter);
        }
        return buf.toString();
    }

    public boolean isBlank(CharSequence cs) {
        if (cs == null || cs.length() == 0) {
            return true;
        }
        int strLen = cs.length();
        return !RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), strLen).exists((Function1)(JFunction1.mcZI.sp & Serializable)i -> !Character.isWhitespace(cs.charAt(i)));
    }

    public boolean isEmpty(CharSequence cs) {
        return cs == null || 0 == cs.length();
    }

    public boolean isEqualSeq(String first, String second) {
        return this.isEqualSeq(first, second, this.DELIMITER());
    }

    public boolean isEqualSeq(String first, String second, String delimiter) {
        if (this.isNotEmpty(first) && this.isNotEmpty(second)) {
            Set set = Predef$.MODULE$.wrapRefArray((Object[])this.split(first, delimiter)).toSet();
            Set set2 = Predef$.MODULE$.wrapRefArray((Object[])this.split(second, delimiter)).toSet();
            return !(set != null ? !set.equals(set2) : set2 != null);
        }
        return this.isEmpty(first) & this.isEmpty(second);
    }

    public boolean isNotBlank(CharSequence cs) {
        return !this.isBlank(cs);
    }

    public boolean isNotEmpty(CharSequence cs) {
        return cs != null && cs.length() > 0;
    }

    public String join(Iterable<?> seq, String delimiter) {
        if (seq == null) {
            return "";
        }
        StringBuilder aim = new StringBuilder();
        seq.foreach((Function1 & Serializable)one -> {
            if (delimiter != null && aim.length() > 0) {
                aim.append(delimiter);
            }
            return aim.append(one);
        });
        return aim.toString();
    }

    public String join(Seq<String> seq) {
        return this.join((Iterable<?>)seq, this.DELIMITER());
    }

    public String join(String[] seq, String delimiter) {
        if (seq == null) {
            return "";
        }
        int seqLen = seq.length;
        if (seqLen == 1) {
            return seq[0];
        }
        StringBuilder aim = new StringBuilder();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), seq.length).foreach((Function1 & Serializable)i -> Strings$.join$$anonfun$2(delimiter, aim, seq, BoxesRunTime.unboxToInt((Object)i)));
        return aim.toString();
    }

    public String keepSeqUnique(String keyString) {
        List keyList = Predef$.MODULE$.wrapRefArray((Object[])this.split(keyString, ",")).toList();
        Set keys = keyList.toSet();
        StringBuilder keyBuf = new StringBuilder();
        Iterator iter = keyList.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!keys.apply((Object)key)) {
                keyBuf.append(key);
            }
            if (!iter.hasNext()) continue;
            keyBuf.append(',');
        }
        return keyBuf.toString();
    }

    public String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        return this.repeat(padChar, pads).concat(str);
    }

    public String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        return str.concat(this.repeat(padChar, pads));
    }

    public String mergeSeq(String first, String second) {
        return this.mergeSeq(first, second, this.DELIMITER());
    }

    public String mergeSeq(String first, String second, String delimiter) {
        if (this.isNotEmpty(second) && this.isNotEmpty(first)) {
            List firstSeq = Predef$.MODULE$.wrapRefArray((Object[])this.split(first, delimiter)).toList();
            List secondSeq = Predef$.MODULE$.wrapRefArray((Object[])this.split(second, delimiter)).toList();
            List rs = Collections$.MODULE$.union(firstSeq, secondSeq);
            StringBuilder buf = new StringBuilder();
            rs.foreach((Function1 & Serializable)ele -> buf.append(delimiter).append(ele));
            if (buf.length() > 0) {
                buf.append(delimiter);
            }
            return buf.toString();
        }
        return (first == null ? "" : first) + (second == null ? "" : second);
    }

    public String removeWord(String host, String word) {
        return this.removeWord(host, word, this.DELIMITER());
    }

    public String removeWord(String host, String word, String delimiter) {
        if (host.indexOf(word) == -1) {
            return host;
        }
        int beginIndex = host.indexOf(word);
        int endIndex = beginIndex + word.length();
        if (beginIndex == 0) {
            return host.substring(endIndex + 1);
        }
        if (endIndex == host.length()) {
            return host.substring(0, beginIndex - delimiter.length());
        }
        String before = host.substring(0, beginIndex);
        String after = host.substring(endIndex + 1);
        return before + after;
    }

    public String repeat(char ch, int repeat) {
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    public String repeat(String str, int repeat) {
        int n;
        if (str == null) {
            return null;
        }
        if (repeat <= 1) {
            boolean bl = repeat >= 0;
            if (repeat == 0) {
                return "";
            }
            return str;
        }
        int len = str.length();
        long longSize = (long)len * (long)repeat;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + String.valueOf(longSize));
        }
        char[] array = new char[size];
        str.getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public String replace(String text, String searchString, String replacement) {
        if (this.isEmpty(text) || this.isEmpty(searchString) || replacement == null) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= 16));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public String[] split(String target) {
        return this.split(target, new char[]{',', ';', '\r', '\n', ' '});
    }

    public String[] split(String str, char separatorChar) {
        int i;
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        ListBuffer list = new ListBuffer();
        int start = 0;
        int length = str.length();
        char[] chars = new char[length];
        str.getChars(0, length, chars, 0);
        for (i = 0; i < len; ++i) {
            if (chars[i] != separatorChar) continue;
            if (start < i) {
                this.addNonEmpty((Buffer<String>)list, chars, start, i);
            }
            start = i + 1;
        }
        if (start < i) {
            this.addNonEmpty((Buffer<String>)list, chars, start, i);
        }
        return (String[])list.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public void addNonEmpty(Buffer<String> buffer, char[] chars, int start, int end) {
        String rs = new String(chars, start, end - start).trim();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(rs))) {
            buffer.addOne((Object)rs);
            return;
        }
    }

    public String[] split(String target, char[] separatorChars) {
        if (target == null) {
            return new String[0];
        }
        if (separatorChars.length == 1) {
            return this.split(target, separatorChars[0]);
        }
        char first = separatorChars[0];
        Set all = Predef$.MODULE$.wrapCharArray(separatorChars).toSet();
        char[] sb = target.toCharArray();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), sb.length).withFilter((Function1)(JFunction1.mcZI.sp & Serializable)i -> all.contains((Object)BoxesRunTime.boxToCharacter((char)sb[i]))).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            sb$2[i] = first;
        });
        return this.split(new String(sb), first);
    }

    public String[] split(String str, String separatorChars) {
        int i;
        String sepChars;
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        ListBuffer list = new ListBuffer();
        int start = 0;
        boolean matched = false;
        String string = sepChars = separatorChars == null ? " " : separatorChars;
        for (i = 0; i < len; ++i) {
            if (sepChars.indexOf(Char$.MODULE$.char2int(str.charAt(i))) >= 0) {
                if (matched) {
                    list.$plus$eq((Object)str.substring(start, i));
                    matched = false;
                }
                start = i + 1;
                continue;
            }
            matched = true;
        }
        if (matched) {
            list.$plus$eq((Object)str.substring(start, i));
        }
        return (String[])list.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public int[] splitNumSeq(String numSeq) {
        if (this.isEmpty(numSeq)) {
            return null;
        }
        String[] numArray = this.split(numSeq, ',');
        HashSet numSet = new HashSet();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numArray.length).foreach((Function1 & Serializable)i -> Strings$.splitNumSeq$$anonfun$1(numArray, numSet, BoxesRunTime.unboxToInt((Object)i)));
        return (int[])numSet.toArray(ClassTag$.MODULE$.apply(Integer.TYPE));
    }

    public Seq<Object> splitToInt(String ids) {
        if (this.isEmpty(ids)) {
            return package$.MODULE$.List().empty();
        }
        Object object = Predef$.MODULE$.intArrayOps(Numbers$.MODULE$.toInt(this.split(ids, ',')));
        return ArrayOps$.MODULE$.toIndexedSeq$extension(object);
    }

    public Seq<Object> splitToLong(String ids) {
        if (this.isEmpty(ids)) {
            return package$.MODULE$.List().empty();
        }
        Object object = Predef$.MODULE$.longArrayOps(Numbers$.MODULE$.toLong(this.split(ids, ',')));
        return ArrayOps$.MODULE$.toIndexedSeq$extension(object);
    }

    public String substring(String str, int startIndex, int endIndex) {
        if (str == null) {
            return null;
        }
        int start = startIndex;
        int end = endIndex;
        if (start < 0) {
            start = str.length() + start;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public String subtractSeq(String first, String second) {
        return this.subtractSeq(first, second, this.DELIMITER());
    }

    public String subtractSeq(String first, String second, String delimiter) {
        if (this.isEmpty(first)) {
            return "";
        }
        if (this.isEmpty(second)) {
            StringBuilder builder = new StringBuilder();
            if (!first.startsWith(delimiter)) {
                builder.append(delimiter).append(first);
            }
            if (!first.endsWith(delimiter)) {
                builder.append(first).append(delimiter);
            }
            return builder.toString();
        }
        List firstSeq = Predef$.MODULE$.wrapRefArray((Object[])this.split(first, delimiter)).toList();
        List secondSeq = Predef$.MODULE$.wrapRefArray((Object[])this.split(second, delimiter)).toList();
        List rs = Collections$.MODULE$.subtract(firstSeq, secondSeq);
        StringBuilder buf = new StringBuilder();
        rs.foreach((Function1 & Serializable)ele -> buf.append(delimiter).append(ele));
        if (buf.length() > 0) {
            buf.append(delimiter);
        }
        return buf.toString();
    }

    public String unCamel(String str) {
        return this.unCamel(str, '-', true);
    }

    public String unCamel(String str, char seperator) {
        return this.unCamel(str, seperator, true);
    }

    public String unCamel(String str, char seperator, boolean lowercase) {
        if (3 > str.length()) {
            if (lowercase) {
                return str.toLowerCase();
            }
            return str;
        }
        char[] ca = str.toCharArray();
        StringBuilder build = new StringBuilder(ca.length + 5);
        build.append(lowercase ? Character.toLowerCase(ca[0]) : ca[0]);
        boolean lower1 = Character.isLowerCase(ca[0]);
        int i = 1;
        while (i < ca.length - 1) {
            char cur = ca[i];
            char next = ca[i + 1];
            boolean upper2 = Character.isUpperCase(cur);
            boolean lower3 = Character.isLowerCase(next);
            if (lower1 && upper2 && lower3) {
                build.append(seperator);
                build.append(lowercase ? Character.toLowerCase(cur) : cur);
                build.append(next);
                i += 2;
                continue;
            }
            StringBuilder stringBuilder = lowercase && upper2 ? build.append(Character.toLowerCase(cur)) : build.append(cur);
            lower1 = !upper2;
            ++i;
        }
        if (i == ca.length - 1) {
            if (Character.isLowerCase(ca[i - 1]) && Character.isUpperCase(ca[i])) {
                build.append(seperator);
            }
            build.append(lowercase ? Character.toLowerCase(ca[i]) : ca[i]);
        }
        return build.toString();
    }

    public String substringBefore(String str, String separator) {
        if (this.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.length() == 0) {
            return Empty;
        }
        int pos = str.indexOf(separator);
        if (pos == Index_not_found) {
            return str;
        }
        return str.substring(0, pos);
    }

    public String substringAfter(String str, String separator) {
        if (this.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return Empty;
        }
        int pos = str.indexOf(separator);
        if (pos == Index_not_found) {
            return Empty;
        }
        return str.substring(pos + separator.length());
    }

    public String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != Index_not_found && (end = str.indexOf(close, start + open.length())) != Index_not_found) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public String substringBeforeLast(String str, String separator) {
        if (this.isEmpty(str) || this.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == Index_not_found) {
            return str;
        }
        return str.substring(0, pos);
    }

    public String substringAfterLast(String str, String separator) {
        if (this.isEmpty(str)) {
            return str;
        }
        if (this.isEmpty(separator)) {
            return Empty;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == Index_not_found || pos == str.length() - separator.length()) {
            return Empty;
        }
        return str.substring(pos + separator.length());
    }

    public String trim(String str) {
        if (str == null) {
            return null;
        }
        return str.trim();
    }

    public String trimEnd(String str) {
        int len;
        if (str == null) {
            return null;
        }
        for (len = str.length(); len > 0 && str.charAt(len - 1) <= ' '; --len) {
        }
        if (len < str.length()) {
            return str.substring(0, len);
        }
        return str;
    }

    public String stripEnd(String str, String stripChars) {
        int end;
        if (str == null || str.length() == 0 || stripChars == null || stripChars.length() == 0) {
            return str;
        }
        for (end = str.length(); end != 0 && stripChars.indexOf(Char$.MODULE$.char2int(str.charAt(end - 1))) != -1; --end) {
        }
        return str.substring(0, end);
    }

    public String uncapitalize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char head = str.charAt(0);
        char lower = Character.toLowerCase(head);
        if (lower == head) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = lower;
        return new String(chars);
    }

    public <T extends CharSequence> T defaultIfBlank(T str, T defaultStr) {
        if (this.isBlank(str)) {
            return defaultStr;
        }
        return str;
    }

    public String lowerCase(String s) {
        if (s == null) {
            return null;
        }
        return s.toLowerCase();
    }

    public String upperCase(String s) {
        if (s == null) {
            return null;
        }
        return s.toUpperCase();
    }

    public String abbreviate(String str, int maxWidth) {
        return this.abbreviate(str, 0, maxWidth);
    }

    public String abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        int newoffset = offset;
        if (newoffset > str.length()) {
            newoffset = str.length();
        }
        if (str.length() - newoffset < maxWidth - 3) {
            newoffset = str.length() - (maxWidth - 3);
        }
        String abrevMarker = "...";
        if (newoffset <= 4) {
            return str.substring(0, maxWidth - 3) + abrevMarker;
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (newoffset + maxWidth - 3 < str.length()) {
            return abrevMarker + this.abbreviate(str.substring(newoffset), maxWidth - 3);
        }
        return abrevMarker + str.substring(str.length() - (maxWidth - 3));
    }

    public String remove(String str, char remove) {
        if (this.isEmpty(str) || str.indexOf(Char$.MODULE$.char2int(remove)) == -1) {
            return str;
        }
        char[] chars = str.toCharArray();
        int pos = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == remove) continue;
            chars[pos] = chars[i];
            ++pos;
        }
        return new String(chars, 0, pos);
    }

    public String format(String format, Seq<Object> args) {
        return new Formatter().format(format, (Object[])args.toArray(ClassTag$.MODULE$.Any())).toString();
    }

    private static final int indexOf$$anonfun$2() {
        return -1;
    }

    private static final /* synthetic */ StringBuilder join$$anonfun$2(String delimiter$3, StringBuilder aim$2, String[] seq$1, int i) {
        if (delimiter$3 != null && i > 0) {
            aim$2.append(delimiter$3);
        }
        return aim$2.append(seq$1[i]);
    }

    private static final /* synthetic */ Object splitNumSeq$$anonfun$1(String[] numArray$1, HashSet numSet$1, int i) {
        String num = numArray$1[i];
        if (num.contains("-")) {
            String[] termFromTo = MODULE$.split(num, '-');
            int from = Numbers$.MODULE$.toInt(termFromTo[0], Numbers$.MODULE$.toInt$default$2());
            int to = Numbers$.MODULE$.toInt(termFromTo[1], Numbers$.MODULE$.toInt$default$2());
            for (int j = from; j <= to; ++j) {
                numSet$1.add((Object)BoxesRunTime.boxToInteger((int)j));
            }
            return BoxedUnit.UNIT;
        }
        return BoxesRunTime.boxToBoolean((boolean)numSet$1.add((Object)BoxesRunTime.boxToInteger((int)Numbers$.MODULE$.toInt(num, Numbers$.MODULE$.toInt$default$2()))));
    }
}

