/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.beangle.commons.lang.SystemInfo$;
import scala.;
import scala.$less$colon$less$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;

public final class SystemInfo {
    public static Host host() {
        return SystemInfo$.MODULE$.host();
    }

    public static Java java() {
        return SystemInfo$.MODULE$.java();
    }

    public static JavaSpec javaSpec() {
        return SystemInfo$.MODULE$.javaSpec();
    }

    public static JavaRuntime jre() {
        return SystemInfo$.MODULE$.jre();
    }

    public static Jvm jvm() {
        return SystemInfo$.MODULE$.jvm();
    }

    public static JvmSpec jvmSpec() {
        return SystemInfo$.MODULE$.jvmSpec();
    }

    public static Os os() {
        return SystemInfo$.MODULE$.os();
    }

    public static Map<String, String> properties() {
        return SystemInfo$.MODULE$.properties();
    }

    public static String tmpDir() {
        return SystemInfo$.MODULE$.tmpDir();
    }

    public static User user() {
        return SystemInfo$.MODULE$.user();
    }

    public static class Host {
        public String hostname() {
            String string;
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                string = "unknownhost";
            }
            return string;
        }

        public Map<String, List<String>> addresses() {
            HashMap addresses = new HashMap();
            try {
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                while (e.hasMoreElements()) {
                    NetworkInterface networkInterface = e.nextElement();
                    String name = networkInterface.getDisplayName();
                    Enumeration<InetAddress> e2 = networkInterface.getInetAddresses();
                    while (e2.hasMoreElements()) {
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
                        String string2 = e2.nextElement().getHostAddress();
                        addresses.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)((List)addresses.getOrElse((Object)name, SystemInfo$::org$beangle$commons$lang$SystemInfo$Host$$_$addresses$$anonfun$1)).$colon$colon((Object)string2)));
                    }
                }
            }
            catch (Exception e) {
            }
            return addresses.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
    }

    public static class Java {
        private final String version;
        private final String vendor;
        private final String vendorUrl;

        public Java(Map<String, String> properties) {
            this.version = (String)properties.apply((Object)"java.version");
            this.vendor = (String)properties.apply((Object)"java.vendor");
            this.vendorUrl = (String)properties.apply((Object)"java.vendor.url");
        }

        public String version() {
            return this.version;
        }

        public String vendor() {
            return this.vendor;
        }

        public String vendorUrl() {
            return this.vendorUrl;
        }
    }

    public static class JavaRuntime {
        private final String name;
        private final String version;
        private final String home;
        private final String classpath;
        private final String classVersion;
        private final String libraryPath;
        private final String tmpDir;
        private final String fileEncoding;

        public JavaRuntime(Map<String, String> properties) {
            this.name = (String)properties.apply((Object)"java.runtime.name");
            this.version = (String)properties.apply((Object)"java.runtime.version");
            this.home = (String)properties.apply((Object)"java.home");
            this.classpath = (String)properties.apply((Object)"java.class.path");
            this.classVersion = (String)properties.apply((Object)"java.class.version");
            this.libraryPath = (String)properties.apply((Object)"java.library.path");
            this.tmpDir = (String)properties.apply((Object)"java.io.tmpdir");
            this.fileEncoding = (String)properties.apply((Object)"file.encoding");
        }

        public String name() {
            return this.name;
        }

        public String version() {
            return this.version;
        }

        public String home() {
            return this.home;
        }

        public String classpath() {
            return this.classpath;
        }

        public String classVersion() {
            return this.classVersion;
        }

        public String libraryPath() {
            return this.libraryPath;
        }

        public String tmpDir() {
            return this.tmpDir;
        }

        public String fileEncoding() {
            return this.fileEncoding;
        }
    }

    public static class JavaSpec {
        private final String name;
        private final String version;
        private final String vendor;

        public JavaSpec(Map<String, String> properties) {
            this.name = (String)properties.apply((Object)"java.specification.name");
            this.version = (String)properties.apply((Object)"java.specification.version");
            this.vendor = (String)properties.apply((Object)"java.specification.vendor");
        }

        public String name() {
            return this.name;
        }

        public String version() {
            return this.version;
        }

        public String vendor() {
            return this.vendor;
        }
    }

    public static class Jvm {
        private final String name;
        private final String version;
        private final String vendor;
        private final String info;

        public Jvm(Map<String, String> properties) {
            this.name = (String)properties.apply((Object)"java.vm.name");
            this.version = (String)properties.apply((Object)"java.vm.version");
            this.vendor = (String)properties.apply((Object)"java.vm.vendor");
            this.info = (String)properties.apply((Object)"java.vm.info");
        }

        public String name() {
            return this.name;
        }

        public String version() {
            return this.version;
        }

        public String vendor() {
            return this.vendor;
        }

        public String info() {
            return this.info;
        }
    }

    public static class JvmSpec {
        private final String name;
        private final String version;
        private final String vendor;

        public JvmSpec(Map<String, String> properties) {
            this.name = (String)properties.apply((Object)"java.vm.specification.name");
            this.version = (String)properties.apply((Object)"java.vm.specification.version");
            this.vendor = (String)properties.apply((Object)"java.vm.specification.vendor");
        }

        public String name() {
            return this.name;
        }

        public String version() {
            return this.version;
        }

        public String vendor() {
            return this.vendor;
        }
    }

    public static class Os {
        private final String name;
        private final String version;
        private final String arch;
        private final String fileSeparator;
        private final String lineSeparator;
        private final String pathSeparator;

        public Os(Map<String, String> properties) {
            this.name = (String)properties.apply((Object)"os.name");
            this.version = (String)properties.apply((Object)"os.version");
            this.arch = (String)properties.apply((Object)"os.arch");
            this.fileSeparator = (String)properties.apply((Object)"file.separator");
            this.lineSeparator = (String)properties.apply((Object)"line.separator");
            this.pathSeparator = (String)properties.apply((Object)"path.separator");
        }

        public String name() {
            return this.name;
        }

        public String version() {
            return this.version;
        }

        public String arch() {
            return this.arch;
        }

        public String fileSeparator() {
            return this.fileSeparator;
        }

        public String lineSeparator() {
            return this.lineSeparator;
        }

        public String pathSeparator() {
            return this.pathSeparator;
        }
    }

    public static class User {
        private final String name;
        private final String home;
        private final String dir;
        private final String language;
        private final String country;

        public User(Map<String, String> properties) {
            String c;
            this.name = (String)properties.apply((Object)"user.name");
            this.home = (String)properties.apply((Object)"user.home");
            this.dir = (String)properties.apply((Object)"user.dir");
            this.language = (String)properties.apply((Object)"user.language");
            Option option = properties.get((Object)"user.country");
            this.country = option instanceof Some ? (c = (String)((Some)option).value()) : (String)properties.get((Object)"user.region").orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public String name() {
            return this.name;
        }

        public String home() {
            return this.home;
        }

        public String dir() {
            return this.dir;
        }

        public String language() {
            return this.language;
        }

        public String country() {
            return this.country;
        }
    }
}

