/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang.reflect;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.commons.lang.Primitives$;
import org.beangle.commons.lang.reflect.TypeInfo;
import org.beangle.commons.lang.reflect.TypeInfo$;
import org.beangle.commons.lang.reflect.TypeInfo$GeneralType$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class Reflections$
implements Serializable {
    public static final Reflections$ MODULE$ = new Reflections$();

    private Reflections$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Reflections$.class);
    }

    public <T> T newInstance(Class<T> clazz) {
        T t;
        block4: {
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                return null;
            }
            try {
                if (clazz.getDeclaredConstructors().length == 0) {
                    t = Primitives$.MODULE$.default(clazz);
                    break block4;
                }
                t = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                t = null;
            }
        }
        return t;
    }

    public Option<Field> getField(Class<?> clazz, String name) {
        Some some;
        try {
            some = Some$.MODULE$.apply((Object)clazz.getField(name));
        }
        catch (NoSuchFieldException e) {
            Option<Field> res = None$.MODULE$;
            for (Class<?> superClass = clazz; res.isEmpty() && superClass != null; superClass = superClass.getSuperclass()) {
                Class<?> clazz2 = superClass;
                Class<Object> clazz3 = Object.class;
                if (!(clazz2 == null ? clazz3 != null : !clazz2.equals(clazz3))) break;
                res = this.getDeclaredField(superClass, name);
            }
            some = res;
        }
        return some;
    }

    private Option<Field> getDeclaredField(Class<?> clazz, String name) {
        None$ none$;
        try {
            Field f = clazz.getDeclaredField(name);
            f.setAccessible(true);
            none$ = Some$.MODULE$.apply((Object)f);
        }
        catch (NoSuchFieldException e) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public <T> T newInstance(String className) {
        return this.newInstance(className, null);
    }

    public <T> T newInstance(String className, ClassLoader classLoader) {
        return (T)this.newInstance(ClassLoaders$.MODULE$.load(className, classLoader));
    }

    public <T> T getInstance(String name) {
        Object companionClass = name.endsWith("$") ? name : name + "$";
        Option<Class<?>> option = ClassLoaders$.MODULE$.get((String)companionClass, ClassLoaders$.MODULE$.get$default$2());
        if (option instanceof Some) {
            Class clazz = (Class)((Some)option).value();
            if (clazz.getConstructors().length > 0) {
                return this.newInstance(clazz);
            }
            return (T)clazz.getDeclaredField("MODULE$").get(null);
        }
        if (None$.MODULE$.equals(option)) {
            return (T)this.newInstance(ClassLoaders$.MODULE$.load(name, ClassLoaders$.MODULE$.load$default$2()));
        }
        throw new MatchError(option);
    }

    public Map<String, Class<?>> getGenericParamTypes(Class<?> clazz, Class<?> expected) {
        if (!expected.isAssignableFrom(clazz)) {
            return Predef$.MODULE$.Map().empty();
        }
        return this.getGenericParamTypes(clazz, (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{expected})));
    }

    public ArraySeq<TypeInfo> getCollectionParamTypes(Class<?> clazz) {
        Set collections = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{Seq.class, scala.collection.immutable.Seq.class, Collection.class}));
        Map<String, Class<?>> types = this.getGenericParamTypes(clazz, collections);
        if (types.isEmpty()) {
            return (ArraySeq)ArraySeq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeInfo.GeneralType[]{TypeInfo$.MODULE$.AnyRefType()}), (Object)ClassTag$.MODULE$.apply(TypeInfo.GeneralType.class));
        }
        Object object = ((Tuple2)types.head())._2();
        Class<?> clazz2 = clazz;
        if (!(object != null ? !object.equals(clazz2) : clazz2 != null)) {
            return (ArraySeq)ArraySeq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeInfo.GeneralType[]{TypeInfo$GeneralType$.MODULE$.apply(clazz, TypeInfo$GeneralType$.MODULE$.$lessinit$greater$default$2())}), (Object)ClassTag$.MODULE$.apply(TypeInfo.GeneralType.class));
        }
        return (ArraySeq)ArraySeq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeInfo[]{TypeInfo$.MODULE$.get((Class)((Tuple2)types.head())._2(), false)}), (Object)ClassTag$.MODULE$.apply(TypeInfo.class));
    }

    public ArraySeq<TypeInfo> getMapParamTypes(Class<?> clazz) {
        Set maps = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{scala.collection.mutable.Map.class, scala.collection.immutable.Map.class, java.util.Map.class}));
        Map<String, Class<?>> types = this.getGenericParamTypes(clazz, maps);
        if (types.isEmpty()) {
            return (ArraySeq)ArraySeq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeInfo.GeneralType[]{TypeInfo$.MODULE$.AnyRefType(), TypeInfo$.MODULE$.AnyRefType()}), (Object)ClassTag$.MODULE$.apply(TypeInfo.GeneralType.class));
        }
        return (ArraySeq)ArraySeq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeInfo[]{TypeInfo$.MODULE$.get((Class)types.apply((Object)"K"), false), TypeInfo$.MODULE$.get((Class)types.apply((Object)"V"), false)}), (Object)ClassTag$.MODULE$.apply(TypeInfo.class));
    }

    public Map<String, Class<?>> getGenericParamTypes(Class<?> clazz, Set<Class<?>> expects) {
        Map<String, Class<?>> targetParamTypes = Predef$.MODULE$.Map().empty();
        Map<String, Class<?>> paramTypes = Predef$.MODULE$.Map().empty();
        Class<?> nextClass = clazz;
        while (nextClass != null && !Object.class.equals(nextClass) && targetParamTypes.isEmpty()) {
            targetParamTypes = this.navIterface(nextClass, expects, paramTypes);
            if (!targetParamTypes.isEmpty()) continue;
            Type nextType = nextClass.getGenericSuperclass();
            nextClass = nextClass.getSuperclass();
            paramTypes = this.deduceParamTypes(nextClass, nextType, paramTypes);
            if (!expects.contains(nextClass)) continue;
            targetParamTypes = paramTypes;
        }
        return targetParamTypes;
    }

    private boolean isAssignableFrom(Set<Class<?>> targets, Class<?> source) {
        return targets.exists((Function1 & Serializable)_$1 -> _$1.isAssignableFrom(source));
    }

    private Map<String, Class<?>> navIterface(Class<?> clazz, Set<Class<?>> targets, Map<String, Class<?>> paramTypes) {
        if (clazz == null || Object.class.equals(clazz)) {
            return null;
        }
        Object[] interfaceTypes = clazz.getGenericInterfaces();
        Object object = Predef$.MODULE$.refArrayOps(interfaceTypes);
        Option canidateIterface = ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)x -> {
            Type type = x;
            if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                return MODULE$.isAssignableFrom(targets, (Class)pt.getRawType());
            }
            if (type instanceof Class) {
                Class c = (Class)type;
                return MODULE$.isAssignableFrom(targets, c);
            }
            return false;
        });
        ObjectRef result = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        canidateIterface.foreach((Function1)(JProcedure1 & Serializable)ci -> {
            Type type = ci;
            if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                Class clazz = (Class)pt.getRawType();
                Map<String, Class<?>> newParamTypes = MODULE$.deduceParamTypes(clazz, pt, paramTypes);
                if (targets.contains((Object)clazz)) {
                    result$1.elem = newParamTypes;
                    return;
                }
                result$1.elem = MODULE$.navIterface(clazz, targets, newParamTypes);
                return;
            }
            if (type instanceof Class) {
                Class c = (Class)type;
                if (!targets.contains((Object)c)) {
                    result$1.elem = MODULE$.navIterface(c, targets, paramTypes);
                    return;
                }
                return;
            }
        });
        return (Map)result.elem;
    }

    public <T extends Annotation> boolean isAnnotationPresent(Method method, Class<T> clazz) {
        T ann = method.getAnnotation(clazz);
        if (ann == null) {
            boolean bl;
            Class<?> delaringClass = method.getDeclaringClass();
            Class<?> superClass = delaringClass.getSuperclass();
            if (superClass == null) {
                return false;
            }
            try {
                bl = this.isAnnotationPresent(superClass.getMethod(method.getName(), method.getParameterTypes()), clazz);
            }
            catch (NoSuchMethodException e) {
                bl = false;
            }
            return bl;
        }
        return true;
    }

    public <T extends Annotation> Tuple2<T, Method> getAnnotation(Method method, Class<T> clazz) {
        T ann = method.getAnnotation(clazz);
        if (ann == null) {
            Tuple2<T, Method> tuple2;
            Class<?> delaringClass = method.getDeclaringClass();
            Class<?> superClass = delaringClass.getSuperclass();
            if (superClass == null) {
                return null;
            }
            try {
                tuple2 = this.getAnnotation(superClass.getMethod(method.getName(), method.getParameterTypes()), clazz);
            }
            catch (NoSuchMethodException e) {
                tuple2 = null;
            }
            return tuple2;
        }
        return Tuple2$.MODULE$.apply(ann, (Object)method);
    }

    public Map<String, Class<?>> deduceParamTypes(Class<?> clazz, Type typ, Map<String, Class<?>> paramTypes) {
        Type type = typ;
        if (type instanceof ParameterizedType) {
            ParameterizedType ptSuper = (ParameterizedType)type;
            HashMap tmp = new HashMap();
            Type[] ps = ptSuper.getActualTypeArguments();
            TypeVariable[] tvs = clazz.getTypeParameters();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ps.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)k -> {
                Some some;
                Type type = ps[k];
                if (type instanceof Class) {
                    Class c = (Class)type;
                    some = Some$.MODULE$.apply((Object)c);
                } else if (type instanceof TypeVariable) {
                    TypeVariable tv = (TypeVariable)type;
                    some = paramTypes.get((Object)tv.getName());
                } else if (type instanceof ParameterizedType) {
                    ParameterizedType pt2 = (ParameterizedType)type;
                    some = Some$.MODULE$.apply((Object)((Class)pt2.getRawType()));
                } else {
                    throw new MatchError((Object)type);
                }
                Some paramType = some;
                paramType.foreach((Function1 & Serializable)pt -> tmp.put((Object)tvs[k].getName(), pt));
            });
            return tmp;
        }
        return Predef$.MODULE$.Map().empty();
    }
}

