/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang.text;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import org.beangle.commons.lang.Options$;
import org.beangle.commons.lang.Primitives$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.text.CalendarFormatter;
import org.beangle.commons.lang.text.DateFormatter;
import org.beangle.commons.lang.text.Formatter;
import org.beangle.commons.lang.text.InstantFormatter;
import org.beangle.commons.lang.text.NumberFormatter;
import org.beangle.commons.lang.text.TemporalFormatter;
import org.beangle.commons.lang.text.ToStringFormatter$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Formatters$
implements Serializable {
    private static final DateFormatter JuDate;
    private static final DateFormatter JuTime;
    private static final DateFormatter JuDateTime;
    private static final CalendarFormatter JuCalendarDateTime;
    private static final Map Defaults;
    public static final Formatters$ MODULE$;

    private Formatters$() {
    }

    static {
        MODULE$ = new Formatters$();
        NumberFormatter PlainNum = new NumberFormatter("0");
        NumberFormatter LongNum = new NumberFormatter("#,##0");
        NumberFormatter DecimalNum = new NumberFormatter("#,##0.##");
        JuDate = new DateFormatter("yyyy-MM-dd");
        JuTime = new DateFormatter("HH:mm:ss");
        JuDateTime = new DateFormatter("yyyy-MM-dd HH:mm:ss");
        JuCalendarDateTime = new CalendarFormatter("yyyy-MM-dd HH:mm:ss");
        TemporalFormatter JtDate = new TemporalFormatter("yyyy-MM-dd");
        TemporalFormatter JtTime = new TemporalFormatter("HH:mm:ss");
        TemporalFormatter JtDateTime = new TemporalFormatter("yyyy-MM-dd HH:mm:ss");
        TemporalFormatter JtOffsetDateTime = new TemporalFormatter("yyyy-MM-dd HH:mm:ssXXX");
        InstantFormatter JtInstant = new InstantFormatter("yyyy-MM-dd HH:mm:ssXXX");
        TemporalFormatter JtYearMonth = new TemporalFormatter("yyyy-MM");
        TemporalFormatter JtMonthDay = new TemporalFormatter("MM-dd");
        Object[] objectArray = new Tuple2[21];
        Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(Boolean.class);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)ToStringFormatter$.MODULE$);
        Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(Short.class);
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)PlainNum);
        Class clazz3 = (Class)Predef$.MODULE$.ArrowAssoc(Integer.class);
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz3, (Object)PlainNum);
        Class clazz4 = (Class)Predef$.MODULE$.ArrowAssoc(Long.class);
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz4, (Object)LongNum);
        Class clazz5 = (Class)Predef$.MODULE$.ArrowAssoc(Float.class);
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz5, (Object)DecimalNum);
        Class clazz6 = (Class)Predef$.MODULE$.ArrowAssoc(Double.class);
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz6, (Object)DecimalNum);
        Class clazz7 = (Class)Predef$.MODULE$.ArrowAssoc(java.math.BigDecimal.class);
        objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz7, (Object)DecimalNum);
        Class clazz8 = (Class)Predef$.MODULE$.ArrowAssoc(BigDecimal.class);
        objectArray[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz8, (Object)DecimalNum);
        Class clazz9 = (Class)Predef$.MODULE$.ArrowAssoc(BigInteger.class);
        objectArray[8] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz9, (Object)LongNum);
        Class clazz10 = (Class)Predef$.MODULE$.ArrowAssoc(Date.class);
        objectArray[9] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz10, (Object)JuDate);
        Class clazz11 = (Class)Predef$.MODULE$.ArrowAssoc(LocalDate.class);
        objectArray[10] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz11, (Object)JtDate);
        Class clazz12 = (Class)Predef$.MODULE$.ArrowAssoc(Time.class);
        objectArray[11] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz12, (Object)JuTime);
        Class clazz13 = (Class)Predef$.MODULE$.ArrowAssoc(LocalTime.class);
        objectArray[12] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz13, (Object)JtTime);
        Class clazz14 = (Class)Predef$.MODULE$.ArrowAssoc(Timestamp.class);
        objectArray[13] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz14, (Object)JuDateTime);
        Class clazz15 = (Class)Predef$.MODULE$.ArrowAssoc(LocalDateTime.class);
        objectArray[14] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz15, (Object)JtDateTime);
        Class clazz16 = (Class)Predef$.MODULE$.ArrowAssoc(java.util.Date.class);
        objectArray[15] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz16, (Object)JuDateTime);
        Class clazz17 = (Class)Predef$.MODULE$.ArrowAssoc(ZonedDateTime.class);
        objectArray[16] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz17, (Object)JtOffsetDateTime);
        Class clazz18 = (Class)Predef$.MODULE$.ArrowAssoc(OffsetDateTime.class);
        objectArray[17] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz18, (Object)JtOffsetDateTime);
        Class clazz19 = (Class)Predef$.MODULE$.ArrowAssoc(Instant.class);
        objectArray[18] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz19, (Object)JtInstant);
        Class clazz20 = (Class)Predef$.MODULE$.ArrowAssoc(YearMonth.class);
        objectArray[19] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz20, (Object)JtYearMonth);
        Class clazz21 = (Class)Predef$.MODULE$.ArrowAssoc(MonthDay.class);
        objectArray[20] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz21, (Object)JtMonthDay);
        Defaults = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Formatters$.class);
    }

    public String format(Object obj, String pattern) {
        Object v = Options$.MODULE$.unwrap(obj);
        if (v == null) {
            return "";
        }
        Formatter formatter = Strings$.MODULE$.isEmpty(pattern) ? this.getDefault(v.getClass()) : this.buildFormatter(v, pattern);
        return formatter.format(v);
    }

    public String format$default$2() {
        return "";
    }

    public String format(Object obj, Formatter formatter) {
        Object v = Options$.MODULE$.unwrap(obj);
        if (v == null) {
            return "";
        }
        return formatter.format(v);
    }

    private Formatter buildFormatter(Object v, String pattern) {
        Object object = v;
        if (object instanceof Number) {
            Number n = (Number)object;
            return new NumberFormatter(pattern);
        }
        if (object instanceof TemporalAccessor) {
            TemporalAccessor t = (TemporalAccessor)object;
            return new TemporalFormatter(pattern);
        }
        if (object instanceof java.util.Date) {
            java.util.Date d = (java.util.Date)object;
            return new DateFormatter(pattern);
        }
        if (object instanceof Calendar) {
            Calendar c = (Calendar)object;
            return new DateFormatter(pattern);
        }
        if (Strings$.MODULE$.isNotEmpty(pattern)) {
            throw new RuntimeException("Cannot format " + v.getClass().getName() + " using " + pattern);
        }
        return ToStringFormatter$.MODULE$;
    }

    public Map<Class<?>, Formatter> Defaults() {
        return Defaults;
    }

    public Formatter getDefault(Class<?> clazz) {
        Class<?> clz = Primitives$.MODULE$.wrap(clazz);
        Option option = this.Defaults().get(clz);
        if (None$.MODULE$.equals(option)) {
            if (Date.class.isAssignableFrom(clz)) {
                return JuDate;
            }
            if (java.util.Date.class.isAssignableFrom(clz)) {
                return JuDateTime;
            }
            if (Timestamp.class.isAssignableFrom(clz)) {
                return JuDateTime;
            }
            if (Calendar.class.isAssignableFrom(clz)) {
                return JuCalendarDateTime;
            }
            if (Time.class.isAssignableFrom(clz)) {
                return JuTime;
            }
            return ToStringFormatter$.MODULE$;
        }
        if (option instanceof Some) {
            Formatter p = (Formatter)((Some)option).value();
            return p;
        }
        throw new MatchError((Object)option);
    }
}

