/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang.time;

import java.util.concurrent.TimeUnit;
import org.beangle.commons.lang.time.Stopwatch$;
import org.beangle.commons.lang.time.Ticker;
import org.beangle.commons.lang.time.Ticker$;

public class Stopwatch {
    private final Ticker ticker;
    private boolean running;
    private long elapsed;
    private long startTick;

    public static String format(long l, int n) {
        return Stopwatch$.MODULE$.format(l, n);
    }

    public static Ticker $lessinit$greater$default$1() {
        return Stopwatch$.MODULE$.$lessinit$greater$default$1();
    }

    public static boolean $lessinit$greater$default$2() {
        return Stopwatch$.MODULE$.$lessinit$greater$default$2();
    }

    public Stopwatch(Ticker ticker, boolean immediately) {
        this.ticker = ticker;
        if (immediately) {
            this.running_$eq(true);
            this.startTick = ticker.read();
        }
    }

    public Ticker ticker() {
        return this.ticker;
    }

    public boolean running() {
        return this.running;
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    public Stopwatch(boolean immediately) {
        this(Ticker$.MODULE$.systemTicker(), immediately);
    }

    public Stopwatch start() {
        boolean bl = !this.running();
        this.running_$eq(true);
        this.startTick = this.ticker().read();
        return this;
    }

    public Stopwatch stop() {
        long tick = this.ticker().read();
        this.running_$eq(false);
        this.elapsed += tick - this.startTick;
        return this;
    }

    public Stopwatch reset() {
        this.elapsed = 0L;
        this.running_$eq(false);
        return this;
    }

    private long elapsedNanos() {
        if (this.running()) {
            return this.ticker().read() - this.startTick + this.elapsed;
        }
        return this.elapsed;
    }

    public long elapsedTime(TimeUnit desiredUnit) {
        return desiredUnit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    public long elapsedMillis() {
        return this.elapsedTime(TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return Stopwatch$.MODULE$.format(this.elapsedNanos(), 4);
    }
}

