/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang.time;

import java.io.Serializable;
import scala.Function1;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;

public class TimerNode
implements Serializable {
    private static final long serialVersionUID = -6180672043920208784L;
    private final String resource;
    private long startTime;
    private ListBuffer children;
    private long totalTime;

    public TimerNode(String resource, long startTime) {
        this.resource = resource;
        this.startTime = startTime;
        this.children = new ListBuffer();
    }

    public String resource() {
        return this.resource;
    }

    public long startTime() {
        return this.startTime;
    }

    public void startTime_$eq(long x$1) {
        this.startTime = x$1;
    }

    public ListBuffer<TimerNode> children() {
        return this.children;
    }

    public void children_$eq(ListBuffer<TimerNode> x$1) {
        this.children = x$1;
    }

    public long totalTime() {
        return this.totalTime;
    }

    public void totalTime_$eq(long x$1) {
        this.totalTime = x$1;
    }

    public void start(long startTime) {
        this.startTime_$eq(startTime);
    }

    public long end() {
        this.totalTime_$eq(System.currentTimeMillis() - this.startTime());
        return this.totalTime();
    }

    public String getPrintable() {
        return this.getPrintable("");
    }

    public String getPrintable(String indent) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(indent);
        buffer.append("[" + this.totalTime() + "ms] - " + this.resource());
        this.children().foreach((Function1 & Serializable)child -> buffer.append('\n').append(child.getPrintable(indent + "  ")));
        return buffer.toString();
    }
}

