/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang.time;

import java.util.Arrays;
import org.beangle.commons.lang.time.TimerNode;

public class TimerStack {
    private int index = -1;
    private TimerNode[] nodes;

    public TimerStack(TimerNode root, int initCapacity) {
        this.nodes = new TimerNode[initCapacity];
        this.push(root);
    }

    public int index() {
        return this.index;
    }

    public void index_$eq(int x$1) {
        this.index = x$1;
    }

    public TimerNode[] nodes() {
        return this.nodes;
    }

    public void nodes_$eq(TimerNode[] x$1) {
        this.nodes = x$1;
    }

    public TimerStack(TimerNode root) {
        this(root, 15);
    }

    private void ensureCapacity() {
        if (this.index() >= this.nodes().length) {
            int newCapacity = this.nodes().length * 2;
            this.nodes_$eq(Arrays.copyOf(this.nodes(), newCapacity));
            return;
        }
    }

    public void push(TimerNode node) {
        this.ensureCapacity();
        this.nodes()[this.index()] = node;
    }

    public TimerNode pop() {
        if (this.index() < 0) {
            return null;
        }
        TimerNode top = this.nodes()[this.index()];
        this.nodes()[this.index()] = null;
        this.index_$eq(this.index() - 1);
        return top;
    }

    public TimerNode peek() {
        if (this.index() < 0) {
            return null;
        }
        return this.nodes()[this.index()];
    }
}

