/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang.time;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.beangle.commons.bean.component;
import org.beangle.commons.lang.Objects;
import org.beangle.commons.lang.Objects$;
import org.beangle.commons.lang.time.HourMinute;
import org.beangle.commons.lang.time.WeekDay;
import org.beangle.commons.lang.time.WeekDay$;
import org.beangle.commons.lang.time.WeekState;
import org.beangle.commons.lang.time.WeekTime$;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.math.Ordered;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

@component
public class WeekTime
implements Ordered<WeekTime>,
Serializable {
    private LocalDate startOn;
    private HourMinute beginAt;
    private HourMinute endAt;
    private WeekState weekstate;

    public static LocalDate getStartOn(int n, WeekDay weekDay) {
        return WeekTime$.MODULE$.getStartOn(n, weekDay);
    }

    public static Builder newBuilder(LocalDate localDate, WeekDay weekDay) {
        return WeekTime$.MODULE$.newBuilder(localDate, weekDay);
    }

    public static WeekTime of(LocalDate localDate) {
        return WeekTime$.MODULE$.of(localDate);
    }

    public static WeekTime of(LocalDate localDate, HourMinute hourMinute, HourMinute hourMinute2) {
        return WeekTime$.MODULE$.of(localDate, hourMinute, hourMinute2);
    }

    public WeekTime() {
        Ordered.$init$((Ordered)this);
    }

    public LocalDate startOn() {
        return this.startOn;
    }

    public void startOn_$eq(LocalDate x$1) {
        this.startOn = x$1;
    }

    public HourMinute beginAt() {
        return this.beginAt;
    }

    public void beginAt_$eq(HourMinute x$1) {
        this.beginAt = x$1;
    }

    public HourMinute endAt() {
        return this.endAt;
    }

    public void endAt_$eq(HourMinute x$1) {
        this.endAt = x$1;
    }

    public WeekState weekstate() {
        return this.weekstate;
    }

    public void weekstate_$eq(WeekState x$1) {
        this.weekstate = x$1;
    }

    public WeekTime(WeekTime other) {
        this();
        this.startOn_$eq(other.startOn());
        this.beginAt_$eq(other.beginAt());
        this.endAt_$eq(other.endAt());
        this.weekstate_$eq(other.weekstate());
    }

    public List<LocalDate> dates() {
        return this.weekstate().weeks().map((Function1 & Serializable)x -> this.dates$$anonfun$1(BoxesRunTime.unboxToInt((Object)x)));
    }

    public LocalDate firstDay() {
        return this.startOn().plusWeeks(Int$.MODULE$.int2long(this.weekstate().first() - 1));
    }

    public LocalDateTime firstTime() {
        return this.firstDay().atTime(this.beginAt().toLocalTime());
    }

    public LocalDate lastDay() {
        return this.startOn().plusWeeks(Int$.MODULE$.int2long(this.weekstate().last() - 1));
    }

    public WeekDay weekday() {
        return WeekDay$.MODULE$.of(this.startOn());
    }

    public boolean isOverlap(WeekTime o) {
        return (this.startOn().equals(o.startOn()) && this.weekstate().isOverlap(o.weekstate())) & this.beginAt().$less(o.endAt()) & o.beginAt().$less(this.endAt());
    }

    public int compare(WeekTime other) {
        Objects.CompareBuilder compareBuilder = Objects$.MODULE$.compareBuilder();
        Objects.CompareBuilder compareBuilder2 = compareBuilder.add(this.startOn(), other.startOn(), compareBuilder.add$default$3());
        Objects.CompareBuilder compareBuilder3 = compareBuilder2.add(this.beginAt(), other.beginAt(), compareBuilder2.add$default$3());
        Objects.CompareBuilder compareBuilder4 = compareBuilder3.add(this.endAt(), other.endAt(), compareBuilder3.add$default$3());
        return compareBuilder4.add(this.weekstate(), other.weekstate(), compareBuilder4.add$default$3()).toComparison();
    }

    public String toString() {
        return "[startOn:" + this.startOn() + ", beginAt:" + this.beginAt() + " endAt:" + this.endAt() + " weekstate:" + this.weekstate() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.startOn().hashCode();
        result = prime * result + (this.weekstate() == null ? 0 : this.weekstate().hashCode());
        result = prime * result + (this.beginAt() == null ? 0 : this.beginAt().hashCode());
        result = prime * result + (this.endAt() == null ? 0 : this.endAt().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object == null) {
            return false;
        }
        if (object instanceof WeekTime) {
            WeekTime wt = (WeekTime)object;
            if (wt == this) {
                return true;
            }
            return Objects$.MODULE$.equalsBuilder().add(this.startOn(), wt.startOn()).add(this.beginAt(), wt.beginAt()).add(this.endAt(), wt.endAt()).add(this.weekstate(), wt.weekstate()).isEquals();
        }
        return false;
    }

    public boolean merge(WeekTime w2, int minGap) {
        if (this.mergeable(w2, minGap)) {
            this.doMerge(w2);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mergeable(WeekTime w2, int minGap) {
        LocalDate localDate = this.startOn();
        LocalDate localDate2 = w2.startOn();
        if (localDate == null) {
            if (localDate2 != null) {
                return false;
            }
        } else if (!((Object)localDate).equals(localDate2)) return false;
        WeekState weekState = this.weekstate();
        WeekState weekState2 = w2.weekstate();
        if (!(weekState != null ? !((Object)weekState).equals(weekState2) : weekState2 != null)) {
            if (this.beginAt().interval(w2.endAt()) < minGap) return true;
            if (w2.beginAt().interval(this.endAt()) < minGap) {
                return true;
            }
            if (this.beginAt().value() > w2.endAt().value()) return false;
            if (w2.beginAt().value() > this.endAt().value()) return false;
            return true;
        }
        HourMinute hourMinute = this.beginAt();
        HourMinute hourMinute2 = w2.beginAt();
        if (hourMinute == null) {
            if (hourMinute2 != null) {
                return false;
            }
        } else if (!((Object)hourMinute).equals(hourMinute2)) return false;
        HourMinute hourMinute3 = this.endAt();
        HourMinute hourMinute4 = w2.endAt();
        if (hourMinute3 == null) {
            if (hourMinute4 == null) return true;
            return false;
        } else {
            if (!((Object)hourMinute3).equals(hourMinute4)) return false;
            return true;
        }
    }

    private void doMerge(WeekTime w2) {
        WeekState weekState = this.weekstate();
        WeekState weekState2 = w2.weekstate();
        if (!(weekState != null ? !((Object)weekState).equals(weekState2) : weekState2 != null)) {
            if (w2.beginAt().value() < this.beginAt().value()) {
                this.beginAt_$eq(w2.beginAt());
            }
            if (w2.endAt().value() > this.endAt().value()) {
                this.endAt_$eq(w2.endAt());
                return;
            }
            return;
        }
        this.weekstate_$eq(this.weekstate().$bar(w2.weekstate()));
    }

    private final /* synthetic */ LocalDate dates$$anonfun$1(int x) {
        return this.startOn().plusWeeks(Int$.MODULE$.int2long(x - 1));
    }

    public static class Builder {
        private final LocalDate startOn;
        private final LocalDate firstWeekEndOn;

        public Builder(LocalDate startOn, LocalDate firstWeekEndOn) {
            this.startOn = startOn;
            this.firstWeekEndOn = firstWeekEndOn;
        }

        public Seq<WeekTime> build(WeekDay weekday, Iterable<Object> weeks) {
            return this.build(weekday, (int[])weeks.toArray(ClassTag$.MODULE$.apply(Integer.TYPE)));
        }

        public Seq<WeekTime> build(WeekDay weekday, int[] weeks) {
            HashMap times = new HashMap();
            ObjectRef startDate = ObjectRef.create((Object)this.startOn);
            while (((LocalDate)startDate.elem).getDayOfWeek().getValue() != weekday.id()) {
                startDate.elem = ((LocalDate)startDate.elem).plusDays(1L);
            }
            IntRef minWeek = IntRef.create((int)1);
            if (((LocalDate)startDate.elem).isAfter(this.firstWeekEndOn)) {
                minWeek.elem = 2;
            }
            Object object = Predef$.MODULE$.intArrayOps(weeks);
            ArrayOps$.MODULE$.withFilter$extension(object, (Function1)((JFunction1.mcZI.sp & Serializable)arg_0 -> WeekTime$.org$beangle$commons$lang$time$WeekTime$Builder$$_$build$$anonfun$1(minWeek, arg_0))).foreach((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> WeekTime$.org$beangle$commons$lang$time$WeekTime$Builder$$_$build$$anonfun$2(startDate, weekday, times, arg_0)));
            return times.values().toSeq();
        }
    }
}

