/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.regex.AntPathPattern$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public class AntPathPattern {
    private final String text;
    private Pattern pattern;
    private boolean exactMatch;
    private List variables;

    public static boolean isPattern(String string) {
        return AntPathPattern$.MODULE$.isPattern(string);
    }

    public AntPathPattern(String text) {
        this.text = text;
        this.variables = package$.MODULE$.List().empty();
        this.preprocess(text, false);
    }

    public String text() {
        return this.text;
    }

    public List<String> variables() {
        return this.variables;
    }

    public void variables_$eq(List<String> x$1) {
        this.variables = x$1;
    }

    public void preprocess(String pattern, boolean caseSensitive) {
        StringBuilder builder = new StringBuilder();
        Matcher matcher = AntPathPattern$.org$beangle$commons$regex$AntPathPattern$$$DefaultPattern.matcher(pattern);
        int end = 0;
        Buffer vars = Collections$.MODULE$.newBuffer();
        while (matcher.find()) {
            builder.append(this.quote(pattern, end, matcher.start()));
            String matched = matcher.group();
            if ("?".equals(matched)) {
                builder.append('.');
            } else if ("**/".equals(matched) || "/**".equals(matched)) {
                builder.append(".*");
            } else if ("*".equals(matched)) {
                builder.append("[^/]*");
            } else if (matched.startsWith("{") && matched.endsWith("}")) {
                int colonIdx = matched.indexOf(58);
                if (colonIdx == -1) {
                    if (this.isRegex(matched)) {
                        builder.append("(" + matched.substring(1, matched.length() - 1) + ")");
                    } else {
                        builder.append("((?s).*)");
                        vars.addOne((Object)matcher.group(1));
                    }
                } else {
                    String variablePattern = matched.substring(colonIdx + 1, matched.length() - 1);
                    builder.append('(').append(variablePattern).append(')');
                    String variableName = matched.substring(1, colonIdx);
                    vars.addOne((Object)variableName);
                }
            }
            end = matcher.end();
        }
        this.variables_$eq((List<String>)vars.toList());
        if (end == 0) {
            this.exactMatch = true;
            this.pattern = null;
            return;
        }
        this.exactMatch = false;
        builder.append(this.quote(pattern, end, pattern.length()));
        this.pattern = Pattern.compile(builder.toString(), 0x20 | (caseSensitive ? 0 : 2));
    }

    private boolean isRegex(String p) {
        return p.indexOf(42) > 0 || p.indexOf(46) > 0 || p.indexOf(43) > 0 || p.indexOf(91) > 0;
    }

    public int hashCode() {
        return this.text().hashCode();
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof AntPathPattern) {
            AntPathPattern obj2 = (AntPathPattern)object;
            String string = this.text();
            String string2 = obj2.text();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        return false;
    }

    public boolean matches(String path) {
        if (this.exactMatch) {
            String string = this.text();
            String string2 = path;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        return this.pattern.matcher(path).matches();
    }

    public boolean matchStart(String path) {
        if (this.exactMatch) {
            return path.startsWith(this.text());
        }
        Matcher m = this.pattern.matcher(path);
        m.matches();
        return m.hitEnd();
    }

    private String quote(String s, int start, int end) {
        if (start == end) {
            return "";
        }
        return Pattern.quote(s.substring(start, end));
    }

    public String toString() {
        if (this.pattern == null) {
            return "ant:[" + this.text() + "]";
        }
        return Strings$.MODULE$.concat((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"ant:[", this.text(), "] regex:[", this.pattern.toString(), "]"}));
    }
}

