/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.text.i18n;

import java.io.Serializable;
import java.util.Locale;
import org.beangle.commons.text.i18n.TextBundleRegistry;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Set;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class ClassTextFinder {
    private final Locale locale;
    private final TextBundleRegistry registry;

    public ClassTextFinder(Locale locale, TextBundleRegistry registry) {
        this.locale = locale;
        this.registry = registry;
    }

    public Option<String> find(Class<?> clazz, String key) {
        return this.find(clazz, key, (Set<String>)new HashSet());
    }

    private String bundleName(Class<?> clazz) {
        String classFullName = clazz.getName();
        int dollarIdx = classFullName.indexOf(36);
        if (dollarIdx == -1) {
            return classFullName;
        }
        return classFullName.substring(0, dollarIdx);
    }

    private Option<String> find(Class<?> clazz, String key, Set<String> checked) {
        String className = this.bundleName(clazz);
        if (checked.contains((Object)className)) {
            return None$.MODULE$;
        }
        checked.add((Object)className);
        ObjectRef msg = ObjectRef.create(this.getClassMessage(className, key));
        if (((Option)msg.elem).nonEmpty()) {
            return (Option)msg.elem;
        }
        msg.elem = this.getPackageMessage(clazz.getPackageName(), key, checked);
        if (((Option)msg.elem).nonEmpty()) {
            return (Option)msg.elem;
        }
        HashSet interfaces = new HashSet();
        this.collectInterfaces(clazz, (Set<Class<?>>)interfaces);
        interfaces.withFilter((Function1 & Serializable)ifc -> ((Option)msg$1.elem).isEmpty()).foreach((Function1)(JProcedure1 & Serializable)ifc -> {
            msg$2.elem = this.getClassMessage(ifc.getName(), key);
        });
        if (((Option)msg.elem).nonEmpty()) {
            return (Option)msg.elem;
        }
        interfaces.withFilter((Function1 & Serializable)ifc -> ((Option)msg$3.elem).isEmpty()).foreach((Function1)(JProcedure1 & Serializable)ifc -> {
            msg$4.elem = this.getPackageMessage(ifc.getPackageName(), key, checked);
        });
        if (((Option)msg.elem).nonEmpty()) {
            return (Option)msg.elem;
        }
        if (clazz.isInterface()) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])clazz.getInterfaces());
            ArrayOps$.MODULE$.withFilter$extension(object, (Function1 & Serializable)ifc -> ((Option)msg$5.elem).isEmpty()).foreach((Function1)(JProcedure1 & Serializable)ifc -> {
                msg$6.elem = this.find((Class<?>)ifc, key, checked);
            });
            if (((Option)msg.elem).nonEmpty()) {
                return (Option)msg.elem;
            }
        } else {
            Class<?> superClass = clazz.getSuperclass();
            if (!superClass.equals(Object.class) && !clazz.isPrimitive()) {
                msg.elem = this.find(superClass, key, checked);
                if (((Option)msg.elem).nonEmpty()) {
                    return (Option)msg.elem;
                }
            }
        }
        return None$.MODULE$;
    }

    private void collectInterfaces(Class<?> me, Set<Class<?>> interfaces) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])me.getInterfaces());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)ifc -> {
            if (!ifc.getName().startsWith("java.") && !ifc.getName().startsWith("scala.")) {
                interfaces.add(ifc);
            }
            this.collectInterfaces((Class<?>)ifc, interfaces);
        });
    }

    public final Option<String> getPackageMessage(String packageName, String key, Set<String> checked) {
        if (checked.contains((Object)packageName)) {
            return None$.MODULE$;
        }
        checked.add((Object)packageName);
        return this.registry.load(this.locale, packageName + ".package").get(key);
    }

    public final Option<String> getClassMessage(String className, String key) {
        return this.registry.load(this.locale, className).get(key);
    }
}

