/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.text.i18n;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Locale;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Charsets$;
import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.text.i18n.TextBundle;
import org.beangle.commons.text.i18n.TextBundleLoader;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class DefaultTextBundleLoader
implements TextBundleLoader {
    @Override
    public Seq<Tuple2<String, InputStream>> find(Locale locale, String bundleName) {
        Buffer inputs = Collections$.MODULE$.newBuffer();
        String fullName = bundleName.replace('.', '/');
        String localeName = this.toLocaleStr(locale);
        if ("".equals(localeName)) {
            ClassLoaders$.MODULE$.getResource(fullName + ".properties", ClassLoaders$.MODULE$.getResource$default$2()).foreach((Function1 & Serializable)b -> (Buffer)inputs.addOne((Object)Tuple2$.MODULE$.apply((Object)b.toString(), (Object)b.openStream())));
        } else {
            ClassLoaders$.MODULE$.getResource(fullName + "_" + localeName + ".properties", ClassLoaders$.MODULE$.getResource$default$2()).foreach((Function1 & Serializable)b -> (Buffer)inputs.addOne((Object)Tuple2$.MODULE$.apply((Object)b.toString(), (Object)b.openStream())));
            ClassLoaders$.MODULE$.getResource(fullName + "." + localeName, ClassLoaders$.MODULE$.getResource$default$2()).foreach((Function1 & Serializable)b -> (Buffer)inputs.addOne((Object)Tuple2$.MODULE$.apply((Object)b.toString(), (Object)b.openStream())));
        }
        inputs.$plus$plus$eq(this.findExtra(locale, bundleName));
        return inputs;
    }

    public Seq<Tuple2<String, InputStream>> findExtra(Locale locale, String bundleName) {
        return package$.MODULE$.List().empty();
    }

    @Override
    public Map<String, TextBundle> load(Locale locale, String bundleName) {
        int dotIdx;
        scala.collection.mutable.Map results = Collections$.MODULE$.newMap();
        ObjectRef curName = ObjectRef.create((Object)bundleName);
        Seq<Tuple2<String, InputStream>> bundles = this.find(locale, (String)curName.elem);
        if (bundles.isEmpty() && (dotIdx = ((String)curName.elem).lastIndexOf(46)) > 0 && dotIdx < ((String)curName.elem).length() - 1 && Character.isUpperCase(((String)curName.elem).charAt(dotIdx + 1))) {
            curName.elem = ((String)curName.elem).substring(0, dotIdx) + ".package";
            bundles = this.find(locale, (String)curName.elem);
        }
        if (bundles.isEmpty()) {
            v0 = results.put((Object)bundleName, (Object)new TextBundle(locale, (String)curName.elem, (Map<String, String>)Predef$.MODULE$.Map().empty()));
        } else {
            String prefix = Strings$.MODULE$.substringBeforeLast((String)curName.elem, ".") + ".";
            bundles.foreach((Function1)(JProcedure1 & Serializable)b -> {
                this.resolve((InputStream)b._2(), this.resolve$default$2()).foreach((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        Map values = (Map)tuple2._2();
                        Object key = name.isEmpty() ? (String)curName$2.elem : prefix + name;
                        Option option = results.get(key);
                        if (None$.MODULE$.equals(option)) {
                            return results.put(key, (Object)new TextBundle(locale, (String)b._1(), (Map<String, String>)values));
                        }
                        if (option instanceof Some) {
                            TextBundle existed = (TextBundle)((Some)option).value();
                            return results.put(key, (Object)existed.merge(new TextBundle(locale, (String)b._1(), (Map<String, String>)values)));
                        }
                        throw new MatchError((Object)option);
                    }
                    throw new MatchError((Object)tuple2);
                });
                if (!results.contains((Object)bundleName)) {
                    results.put((Object)bundleName, (Object)new TextBundle(locale, bundleName, (Map<String, String>)Predef$.MODULE$.Map().empty()));
                    return;
                }
            });
            v0 = BoxedUnit.UNIT;
        }
        return results.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private String toLocaleStr(Locale locale) {
        Locale locale2 = locale;
        Locale locale3 = Locale.ROOT;
        if (!(locale2 != null ? !((Object)locale2).equals(locale3) : locale3 != null)) {
            return "";
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        String string = language;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = country;
            String string4 = "";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                String string5 = variant;
                String string6 = "";
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    return "";
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        String string7 = variant;
        String string8 = "";
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            v5 = sb.append(language).append('_').append(country).append('_').append(variant);
        } else {
            String string9 = country;
            String string10 = "";
            v5 = (string9 == null ? string10 != null : !string9.equals(string10)) ? sb.append(language).append('_').append(country) : sb.append(language);
        }
        return sb.toString();
    }

    public Map<String, Map<String, String>> resolve(InputStream input, Charset charset) {
        String defaults = "";
        HashMap texts = new HashMap();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(input, charset));
        String line = reader.readLine();
        while (line != null) {
            int index = line.indexOf(61);
            if (index > 0 && index != line.length() - 1) {
                String key = line.substring(0, index).trim();
                String value2 = line.substring(index + 1).trim();
                if (Character.isUpperCase(key.charAt(0))) {
                    int dotIdx = key.indexOf(46);
                    if (-1 == dotIdx) {
                        ((HashMap)texts.getOrElseUpdate((Object)defaults, DefaultTextBundleLoader::resolve$$anonfun$1)).put((Object)key, (Object)value2);
                    } else {
                        ((HashMap)texts.getOrElseUpdate((Object)key.substring(0, dotIdx), DefaultTextBundleLoader::resolve$$anonfun$2)).put((Object)key.substring(dotIdx + 1), (Object)value2);
                    }
                } else {
                    ((HashMap)texts.getOrElseUpdate((Object)defaults, DefaultTextBundleLoader::resolve$$anonfun$3)).put((Object)key, (Object)value2);
                }
            }
            line = reader.readLine();
        }
        if (!texts.contains((Object)defaults)) {
            texts.put((Object)defaults, (Object)HashMap$.MODULE$.empty());
        }
        HashMap results = (HashMap)texts.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                HashMap values = (HashMap)tuple2._2();
                return Tuple2$.MODULE$.apply((Object)name, (Object)values.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
            throw new MatchError((Object)tuple2);
        });
        return results.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Charset resolve$default$2() {
        return Charsets$.MODULE$.UTF_8();
    }

    private static final HashMap resolve$$anonfun$1() {
        return new HashMap();
    }

    private static final HashMap resolve$$anonfun$2() {
        return new HashMap();
    }

    private static final HashMap resolve$$anonfun$3() {
        return new HashMap();
    }
}

