/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.text.inflector;

import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Matcher;
import org.beangle.commons.text.inflector.Pluralizer;
import org.beangle.commons.text.inflector.Rule;
import org.beangle.commons.text.inflector.RuleBasedPluralizer$;
import scala.Function1;
import scala.collection.immutable.List;
import scala.package$;

public class RuleBasedPluralizer
implements Pluralizer {
    private List rules;
    private Locale locale;
    private Pluralizer fallbackPluralizer;

    public RuleBasedPluralizer(List<Rule> rules, Locale locale, Pluralizer fallbackPluralizer) {
        this.rules = rules;
        this.locale = locale;
        this.fallbackPluralizer = fallbackPluralizer;
    }

    public List<Rule> rules() {
        return this.rules;
    }

    public void rules_$eq(List<Rule> x$1) {
        this.rules = x$1;
    }

    public Locale locale() {
        return this.locale;
    }

    public void locale_$eq(Locale x$1) {
        this.locale = x$1;
    }

    public Pluralizer fallbackPluralizer() {
        return this.fallbackPluralizer;
    }

    public void fallbackPluralizer_$eq(Pluralizer x$1) {
        this.fallbackPluralizer = x$1;
    }

    public RuleBasedPluralizer() {
        this((List<Rule>)package$.MODULE$.List().empty(), Locale.getDefault(), null);
    }

    public RuleBasedPluralizer(List<Rule> rules, Locale locale) {
        this(rules, locale, RuleBasedPluralizer$.org$beangle$commons$text$inflector$RuleBasedPluralizer$$$IDENTITY_PLURALIZER);
    }

    @Override
    public String pluralize(String word) {
        return this.pluralize(word, 2);
    }

    @Override
    public String pluralize(String word, int number) {
        if (number == 1) {
            return word;
        }
        Matcher matcher = RuleBasedPluralizer$.org$beangle$commons$text$inflector$RuleBasedPluralizer$$$pattern.matcher(word);
        if (matcher.matches()) {
            String pre = matcher.group(1);
            String trimmedWord = matcher.group(2);
            String post = matcher.group(3);
            String plural = this.pluralizeInternal(trimmedWord);
            if (plural == null) {
                return this.fallbackPluralizer().pluralize(word, number);
            }
            return pre + this.postProcess(trimmedWord, plural) + post;
        }
        return word;
    }

    public String pluralizeInternal(String word) {
        return (String)this.rules().find((Function1 & Serializable)_$1 -> _$1.applies(word)).map((Function1 & Serializable)_$2 -> _$2.apply(word)).getOrElse(RuleBasedPluralizer::pluralizeInternal$$anonfun$3);
    }

    public String postProcess(String trimmedWord, String pluralizedWord) {
        if (RuleBasedPluralizer$.org$beangle$commons$text$inflector$RuleBasedPluralizer$$$pluPattern1.matcher(trimmedWord).matches()) {
            return pluralizedWord.toUpperCase(this.locale());
        }
        if (RuleBasedPluralizer$.org$beangle$commons$text$inflector$RuleBasedPluralizer$$$pluPattern2.matcher(trimmedWord).matches()) {
            return pluralizedWord.substring(0, 1).toUpperCase(this.locale()) + pluralizedWord.substring(1);
        }
        return pluralizedWord;
    }

    private static final String pluralizeInternal$$anonfun$3() {
        return null;
    }

    public static class IdentityPluralizer
    implements Pluralizer {
        @Override
        public String pluralize(String word) {
            return word;
        }

        @Override
        public String pluralize(String word, int number) {
            return word;
        }
    }
}

