/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.text.inflector.rule;

import java.util.regex.Pattern;
import org.beangle.commons.text.inflector.Rule;

public class SuffixInflectionRule
implements Rule {
    private final String singularSuffix;
    private final String pluralSuffix;
    private final Pattern regex;

    public SuffixInflectionRule(String suffix, String singularSuffix, String pluralSuffix) {
        this.singularSuffix = singularSuffix;
        this.pluralSuffix = pluralSuffix;
        this.regex = Pattern.compile("(?i).*" + suffix.substring(1) + "$");
    }

    public String singularSuffix() {
        return this.singularSuffix;
    }

    public String pluralSuffix() {
        return this.pluralSuffix;
    }

    public SuffixInflectionRule(String singularSuffix, String pluralSuffix) {
        this(singularSuffix, singularSuffix, pluralSuffix);
    }

    @Override
    public boolean applies(String word) {
        return this.regex.matcher(word).matches();
    }

    @Override
    public String apply(String word) {
        int i = word.lastIndexOf(this.singularSuffix().substring(1));
        return word.substring(0, i) + this.pluralSuffix().substring(1);
    }
}

