/*
 * Copyright (C) 2005, The Beangle Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.beangle.commons.text.i18n

import org.beangle.commons.lang.annotation.description

import java.text.MessageFormat
import java.util.Locale
import java.util.concurrent.ConcurrentHashMap

/** DefaultTextFormatter with cache
  *
  * @author chaostone
  * @since 3.0.0
  */
@description("缺省Text格式化")
class DefaultTextFormatter extends TextFormatter {

  protected var caches: Map[Locale, Map[String, MessageFormat]] = Map.empty

  def format(text: String, locale: Locale, args: Any*): String = {
    val format =
      caches.get(locale) match
        case None =>
          val f = new MessageFormat(text)
          caches += (locale, Map(text -> f))
          f
        case Some(map) =>
          map.get(text) match
            case None =>
              val f = new MessageFormat(text)
              caches += (locale, map + (text -> f))
              f
            case Some(format) => format

    format.format(args.toArray)
  }
}
