/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.activation;

import java.io.Serializable;
import java.net.URL;
import org.beangle.commons.activation.MediaType;
import org.beangle.commons.activation.MediaType$;
import org.beangle.commons.config.Resources;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.commons.lang.Strings$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class MediaTypes$
implements Serializable {
    private static final MediaType All;
    private static final Map<String, MediaType> types;
    private static final MediaType ApplicationAtomXml;
    private static final MediaType ApplicationFormUrlencoded;
    private static final MediaType ApplicationJson;
    private static final MediaType ApplicationJsonApi;
    private static final MediaType ApplicationJavascript;
    private static final MediaType ApplicationOctetStream;
    private static final MediaType ApplicationXhtmlXml;
    private static final MediaType ApplicationXml;
    private static final MediaType ApplicationPdf;
    private static final MediaType ApplicationZip;
    private static final MediaType ApplicationXlsx;
    private static final MediaType ApplicationDocx;
    private static final MediaType ImageGif;
    private static final MediaType ImageJpeg;
    private static final MediaType ImagePng;
    private static final MediaType MultipartFormData;
    private static final MediaType TextHtml;
    private static final MediaType TextPlain;
    private static final MediaType TextCsv;
    public static final MediaTypes$ MODULE$;

    private MediaTypes$() {
    }

    static {
        MODULE$ = new MediaTypes$();
        All = MediaType$.MODULE$.apply("*/*");
        types = MODULE$.buildTypes(new Resources(ClassLoaders$.MODULE$.getResource("org/beangle/commons/activation/mime.types", ClassLoaders$.MODULE$.getResource$default$2()), ClassLoaders$.MODULE$.getResources("META-INF/mime.types", ClassLoaders$.MODULE$.getResources$default$2()), ClassLoaders$.MODULE$.getResource("mime.types", ClassLoaders$.MODULE$.getResource$default$2())));
        ApplicationAtomXml = (MediaType)types.apply((Object)"application/atom+xml");
        ApplicationFormUrlencoded = (MediaType)types.apply((Object)"application/x-www-form-urlencoded");
        ApplicationJson = (MediaType)types.apply((Object)"application/json");
        ApplicationJsonApi = (MediaType)types.apply((Object)"application/vnd.api+json");
        ApplicationJavascript = (MediaType)types.apply((Object)"application/javascript");
        ApplicationOctetStream = (MediaType)types.apply((Object)"application/octet-stream");
        ApplicationXhtmlXml = (MediaType)types.apply((Object)"application/xhtml+xml");
        ApplicationXml = (MediaType)types.apply((Object)"application/xml");
        ApplicationPdf = (MediaType)types.apply((Object)"application/pdf");
        ApplicationZip = (MediaType)types.apply((Object)"application/zip");
        ApplicationXlsx = (MediaType)types.apply((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        ApplicationDocx = (MediaType)types.apply((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        ImageGif = (MediaType)types.apply((Object)"image/gif");
        ImageJpeg = (MediaType)types.apply((Object)"image/jpeg");
        ImagePng = (MediaType)types.apply((Object)"image/png");
        MultipartFormData = (MediaType)types.apply((Object)"multipart/form-data");
        TextHtml = (MediaType)types.apply((Object)"text/html");
        TextPlain = (MediaType)types.apply((Object)"text/plain");
        TextCsv = (MediaType)types.apply((Object)"text/csv");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MediaTypes$.class);
    }

    public MediaType All() {
        return All;
    }

    public MediaType ApplicationAtomXml() {
        return ApplicationAtomXml;
    }

    public MediaType ApplicationFormUrlencoded() {
        return ApplicationFormUrlencoded;
    }

    public MediaType ApplicationJson() {
        return ApplicationJson;
    }

    public MediaType ApplicationJsonApi() {
        return ApplicationJsonApi;
    }

    public MediaType ApplicationJavascript() {
        return ApplicationJavascript;
    }

    public MediaType ApplicationOctetStream() {
        return ApplicationOctetStream;
    }

    public MediaType ApplicationXhtmlXml() {
        return ApplicationXhtmlXml;
    }

    public MediaType ApplicationXml() {
        return ApplicationXml;
    }

    public MediaType ApplicationPdf() {
        return ApplicationPdf;
    }

    public MediaType ApplicationZip() {
        return ApplicationZip;
    }

    public MediaType ApplicationXlsx() {
        return ApplicationXlsx;
    }

    public MediaType ApplicationDocx() {
        return ApplicationDocx;
    }

    public MediaType ImageGif() {
        return ImageGif;
    }

    public MediaType ImageJpeg() {
        return ImageJpeg;
    }

    public MediaType ImagePng() {
        return ImagePng;
    }

    public MediaType MultipartFormData() {
        return MultipartFormData;
    }

    public MediaType TextHtml() {
        return TextHtml;
    }

    public MediaType TextPlain() {
        return TextPlain;
    }

    public MediaType TextCsv() {
        return TextCsv;
    }

    public Map<String, MediaType> buildTypes(Resources resources) {
        HashMap buf = new HashMap();
        if (resources != null) {
            resources.paths().foreach((Function1 & Serializable)p -> (HashMap)buf.$plus$plus$eq(MODULE$.readMediaTypes((URL)p)));
        }
        buf.put((Object)"*/*", (Object)this.All());
        return buf.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, MediaType> readMediaTypes(URL url) {
        if (url == null) {
            return Predef$.MODULE$.Map().empty();
        }
        HashMap buf = new HashMap();
        IOs$.MODULE$.readLines(url.openStream(), IOs$.MODULE$.readLines$default$2()).foreach((Function1)(JProcedure1 & Serializable)line -> {
            if (Strings$.MODULE$.isNotBlank((CharSequence)line) && !line.startsWith("#")) {
                String mimetypeStr = Strings$.MODULE$.substringBetween((String)line, "=", "exts").trim();
                Predef$.MODULE$.require(!buf.contains((Object)mimetypeStr), () -> MediaTypes$.readMediaTypes$$anonfun$1$$anonfun$1(mimetypeStr));
                MediaType mimetype = MediaType$.MODULE$.apply(mimetypeStr);
                buf.put((Object)mimetypeStr, (Object)mimetype);
                String exts = Strings$.MODULE$.substringAfter((String)line, "exts").trim().substring(1);
                if (Strings$.MODULE$.isNotBlank(exts)) {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(exts, ','));
                    ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)ext -> {
                        String extension = ext.trim();
                        Option exists = buf.get((Object)extension);
                        Predef$.MODULE$.require(exists.isEmpty(), () -> MediaTypes$.readMediaTypes$$anonfun$1$$anonfun$2$$anonfun$1(extension, exists, mimetype));
                        return buf.put((Object)extension, (Object)mimetype);
                    });
                    return;
                }
                return;
            }
        });
        return buf.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public MediaType get(String ext, MediaType defaultValue) {
        return (MediaType)types.getOrElse((Object)ext, () -> MediaTypes$.get$$anonfun$1(defaultValue));
    }

    public Option<MediaType> get(String ext) {
        return types.get((Object)ext);
    }

    public Seq<MediaType> parse(String str) {
        if (str == null) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        ListBuffer mimeTypes = new ListBuffer();
        Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(str, ","));
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)token -> {
            int commaIndex = token.indexOf(";");
            String mimetype = commaIndex > -1 ? token.substring(0, commaIndex).trim() : token.trim();
            Option option = types.get((Object)mimetype);
            if (option instanceof Some) {
                MediaType mt = (MediaType)((Some)option).value();
                return mimeTypes.$plus$eq((Object)mt);
            }
            if (None$.MODULE$.equals(option)) {
                return MediaType$.MODULE$.apply(mimetype);
            }
            throw new MatchError((Object)option);
        });
        return mimeTypes.toList();
    }

    private static final Object readMediaTypes$$anonfun$1$$anonfun$1(String mimetypeStr$1) {
        return "duplicate mime type:" + mimetypeStr$1;
    }

    private static final Object readMediaTypes$$anonfun$1$$anonfun$2$$anonfun$1(String extension$1, Option exists$1, MediaType mimetype$2) {
        return "exists " + extension$1 + " = " + exists$1.get() + ", the newer is " + mimetype$2;
    }

    private static final MediaType get$$anonfun$1(MediaType defaultValue$1) {
        return defaultValue$1;
    }
}

