/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.collection;

import java.io.Serializable;
import java.util.Map;
import org.beangle.commons.bean.Properties$;
import org.beangle.commons.lang.functor.Predicate;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;

public final class Collections$
implements Serializable {
    public static final Collections$ MODULE$ = new Collections$();

    private Collections$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Collections$.class);
    }

    public boolean isEmpty(Iterable<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public boolean isNotEmpty(Iterable<?> coll) {
        return coll != null && !coll.isEmpty();
    }

    public <T> Option<T> findFirstMatch(Iterable<T> source, Iterable<T> candidates) {
        None$ none$;
        if (this.isNotEmpty(source) && this.isNotEmpty(candidates)) {
            Iterable<T> iterable = source;
            if (iterable instanceof Set) {
                Set set = (Set)iterable;
                none$ = candidates.find((Function1 & Serializable)c -> set.contains(c));
            } else if (iterable instanceof Seq) {
                Seq seq = (Seq)iterable;
                none$ = candidates.find((Function1 & Serializable)c -> seq.contains(c));
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        None$ finded = none$;
        return finded;
    }

    public <T> List<List<T>> split(List<T> list, int count) {
        ListBuffer subLists = new ListBuffer();
        if (list.size() < count) {
            v0 = subLists.$plus$eq(list);
        } else {
            for (int i = 0; i < list.size(); i += count) {
                int end = i + count;
                if (end > list.size()) {
                    end = list.size();
                }
                subLists.$plus$eq((Object)list.slice(i, end));
            }
            v0 = BoxedUnit.UNIT;
        }
        return subLists.toList();
    }

    public Map<?, ?> convertToMap(scala.collection.immutable.Seq<Object> coll, String keyProperty) {
        return ((IterableOnceOps)coll.map((Function1 & Serializable)obj -> Tuple2$.MODULE$.apply(Properties$.MODULE$.get(obj, keyProperty, ClassTag$.MODULE$.apply(Object.class)), obj))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<?, ?> convertToMap(scala.collection.immutable.Seq<Object> coll, String keyProperty, String valueProperty) {
        HashMap map = new HashMap();
        coll.foreach((Function1)(JProcedure1 & Serializable)obj -> {
            Object key = Properties$.MODULE$.get(obj, keyProperty, ClassTag$.MODULE$.apply(Object.class));
            Object value2 = Properties$.MODULE$.get(obj, valueProperty, ClassTag$.MODULE$.apply(Object.class));
            if (key != null) {
                map.put(key, value2);
                return;
            }
        });
        return map.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public <T> List<T> union(Iterable<T> first, Iterable<T> second) {
        Map mapa = this.getCardinalityMap(first);
        Map mapb = this.getCardinalityMap(second);
        HashSet elts = new HashSet();
        elts.$plus$plus$eq(first);
        elts.$plus$plus$eq(second);
        ListBuffer list = new ListBuffer();
        elts.foreach((Function1)(JProcedure1 & Serializable)obj -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), Math.max(MODULE$.getFreq(obj, mapa), MODULE$.getFreq(obj, mapb))).foreach((Function1 & Serializable)i -> Collections$.union$$anonfun$1$$anonfun$1(list, obj, BoxesRunTime.unboxToInt((Object)i))));
        return list.toList();
    }

    public <T> Map<T, Object> getCardinalityMap(Iterable<T> coll) {
        HashMap count = new HashMap();
        for (Object obj : coll) {
            Option option = count.get(obj);
            if (option instanceof Some) {
                int c = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                count.put(obj, (Object)BoxesRunTime.boxToInteger((int)(c + 1)));
                continue;
            }
            count.put(obj, (Object)BoxesRunTime.boxToInteger((int)1));
        }
        return count.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private <T> int getFreq(T obj, Map<T, Object> freqMap) {
        return BoxesRunTime.unboxToInt((Object)freqMap.get(obj).getOrElse(Collections$::getFreq$$anonfun$1));
    }

    public <T> List<T> intersection(Iterable<T> first, Iterable<T> second) {
        ListBuffer list = new ListBuffer();
        Map mapa = this.getCardinalityMap(first);
        Map mapb = this.getCardinalityMap(second);
        HashSet elts = new HashSet();
        elts.$plus$plus$eq(first);
        elts.$plus$plus$eq(second);
        elts.foreach((Function1)(JProcedure1 & Serializable)obj -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), Math.min(MODULE$.getFreq(obj, mapa), MODULE$.getFreq(obj, mapb))).foreach((Function1 & Serializable)i -> Collections$.intersection$$anonfun$1$$anonfun$1(list, obj, BoxesRunTime.unboxToInt((Object)i))));
        return list.toList();
    }

    public <T> List<T> subtract(Iterable<T> first, Iterable<T> second) {
        ListBuffer list = new ListBuffer();
        list.$plus$plus$eq(first);
        second.foreach((Function1 & Serializable)t -> (ListBuffer)list.$minus$eq(t));
        return list.toList();
    }

    public <T> List<T> select(scala.collection.immutable.Seq<T> datas, Predicate<T> predicate) {
        ListBuffer rs = new ListBuffer();
        datas.withFilter((Function1 & Serializable)t -> BoxesRunTime.unboxToBoolean((Object)predicate.apply(t))).foreach((Function1 & Serializable)t -> (ListBuffer)rs.$plus$eq(t));
        return rs.toList();
    }

    public <T> scala.collection.immutable.Set<T> select(scala.collection.immutable.Set<T> datas, Predicate<T> predicate) {
        HashSet rs = new HashSet();
        datas.withFilter((Function1 & Serializable)t -> BoxesRunTime.unboxToBoolean((Object)predicate.apply(t))).foreach((Function1 & Serializable)t -> rs.add(t));
        return rs.toSet();
    }

    public <K, V, V2 extends V> void putAll(HashMap<K, V> target, java.util.Map<K, V2> origin) {
        for (Map.Entry<K, V2> entry : origin.entrySet()) {
            target.put(entry.getKey(), entry.getValue());
        }
    }

    public <T> Buffer<T> newBuffer() {
        return new ArrayBuffer();
    }

    public <T> Buffer<T> newBuffer(Iterable<T> t) {
        ArrayBuffer buffer = new ArrayBuffer();
        buffer.$plus$plus$eq(t);
        return buffer;
    }

    public <T> Buffer<T> newBuffer(T t) {
        ArrayBuffer buffer = new ArrayBuffer();
        buffer.$plus$eq(t);
        return buffer;
    }

    public <T> scala.collection.mutable.Set<T> newSet() {
        return new HashSet();
    }

    public <K, V> scala.collection.mutable.Map<K, V> newMap() {
        return new HashMap();
    }

    private static final /* synthetic */ ListBuffer union$$anonfun$1$$anonfun$1(ListBuffer list$2, Object obj$1, int i) {
        return (ListBuffer)list$2.$plus$eq(obj$1);
    }

    private static final int getFreq$$anonfun$1() {
        return 0;
    }

    private static final /* synthetic */ ListBuffer intersection$$anonfun$1$$anonfun$1(ListBuffer list$4, Object obj$2, int i) {
        return (ListBuffer)list$4.$plus$eq(obj$2);
    }
}

