/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.collection;

import java.io.Serializable;
import org.beangle.commons.collection.FastStack$;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ClassTag;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class FastStack<T> {
    private final ClassTag<T> evidence$1;
    private Object stack;
    private int pointer;

    public static <T> int $lessinit$greater$default$1() {
        return FastStack$.MODULE$.$lessinit$greater$default$1();
    }

    public FastStack(int initialCapacity, ClassTag<T> evidence$1) {
        this.evidence$1 = evidence$1;
        this.stack = Arrays$.MODULE$.newGenericArray(initialCapacity, evidence$1);
        this.pointer = 0;
    }

    public void push(T value2) {
        if (this.pointer + 1 >= ScalaRunTime$.MODULE$.array_length(this.stack)) {
            this.resizeStack(ScalaRunTime$.MODULE$.array_length(this.stack) * 2);
        }
        ScalaRunTime$.MODULE$.array_update(this.stack, this.pointer, value2);
        ++this.pointer;
    }

    public void popSilently() {
        --this.pointer;
        ScalaRunTime$.MODULE$.array_update(this.stack, this.pointer, null);
    }

    public T pop() {
        --this.pointer;
        Object result = ScalaRunTime$.MODULE$.array_apply(this.stack, this.pointer);
        ScalaRunTime$.MODULE$.array_update(this.stack, this.pointer, null);
        return (T)result;
    }

    public T peek() {
        if (this.pointer == 0) {
            return null;
        }
        return (T)ScalaRunTime$.MODULE$.array_apply(this.stack, this.pointer - 1);
    }

    public T replace(T value2) {
        Object result = ScalaRunTime$.MODULE$.array_apply(this.stack, this.pointer - 1);
        ScalaRunTime$.MODULE$.array_update(this.stack, this.pointer - 1, value2);
        return (T)result;
    }

    public int size() {
        return this.pointer;
    }

    public boolean isEmpty() {
        return this.pointer == 0;
    }

    public T get(int i) {
        return (T)ScalaRunTime$.MODULE$.array_apply(this.stack, i);
    }

    public Object toArray() {
        Object result = Arrays$.MODULE$.newGenericArray(this.pointer, this.evidence$1);
        System.arraycopy(this.stack, 0, result, 0, this.pointer);
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.pointer).foreach((Function1 & Serializable)i -> this.toString$$anonfun$1(result, BoxesRunTime.unboxToInt((Object)i)));
        result.append(']');
        return result.toString();
    }

    private void resizeStack(int newCapacity) {
        Object newStack = Arrays$.MODULE$.newGenericArray(newCapacity, this.evidence$1);
        System.arraycopy(this.stack, 0, newStack, 0, Math.min(this.pointer, newCapacity));
        this.stack = newStack;
    }

    private final /* synthetic */ StringBuffer toString$$anonfun$1(StringBuffer result$1, int i) {
        if (i > 0) {
            result$1.append(", ");
        }
        return result$1.append(ScalaRunTime$.MODULE$.array_apply(this.stack, i));
    }
}

