/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.collection;

import java.io.Serializable;
import org.beangle.commons.collection.IdentityMap$;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class IdentityMap<K, V> {
    private final Entry<K, V>[] table;
    private final int mask;

    public static <K, V> int $lessinit$greater$default$1() {
        return IdentityMap$.MODULE$.$lessinit$greater$default$1();
    }

    public IdentityMap(int capacity) {
        Predef$.MODULE$.require(capacity % 2 == 0);
        this.table = new Entry[capacity];
        this.mask = capacity - 1;
    }

    public final V get(K key) {
        int bucket = System.identityHashCode(key) & this.mask;
        for (Entry<K, V> entry = this.table[bucket]; entry != null; entry = entry.next()) {
            if (key != entry.key()) continue;
            return entry.value();
        }
        return null;
    }

    public void clear() {
        Entry<K, V>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
    }

    public boolean contains(K key) {
        return this.get(key) != null;
    }

    public boolean put(K key, V value2) {
        int hash = System.identityHashCode(key) & this.mask;
        Entry<K, V>[] tab = this.table;
        for (Entry<K, V> entry = tab[hash]; entry != null; entry = entry.next()) {
            if (key != entry.key()) continue;
            entry.value_$eq(value2);
            return true;
        }
        tab[hash] = new Entry<K, V>(this, key, value2, tab[hash]);
        return false;
    }

    public V remove(K key) {
        Entry<K, V>[] tab = this.table;
        int hash = System.identityHashCode(key) & this.mask;
        Entry<K, V> prev = null;
        for (Entry<K, V> e = tab[hash]; e != null; e = e.next()) {
            if (key == e.key()) {
                if (prev != null) {
                    prev.next_$eq(e.next());
                } else {
                    tab[hash] = e.next();
                }
                V oldValue = e.value();
                e.value_$eq(null);
                return oldValue;
            }
            prev = e;
        }
        return null;
    }

    public int size() {
        IntRef size = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.table.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)bucket -> {
            for (Entry<K, V> entry = this.table[bucket]; entry != null; entry = entry.next()) {
                ++size$1.elem;
            }
        });
        return size.elem;
    }

    public Iterator<K> keysIterator() {
        return new KeyIterator<K>(this.table);
    }

    public class Entry<K, V> {
        private final Object key;
        private Object value;
        private Entry next;
        private final /* synthetic */ IdentityMap $outer;

        public Entry(IdentityMap $outer, K key, V value2, Entry<K, V> next) {
            this.key = key;
            this.value = value2;
            this.next = next;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public K key() {
            return (K)this.key;
        }

        public V value() {
            return (V)this.value;
        }

        public void value_$eq(V x$1) {
            this.value = x$1;
        }

        public Entry<K, V> next() {
            return this.next;
        }

        public void next_$eq(Entry<K, V> x$1) {
            this.next = x$1;
        }

        public final /* synthetic */ IdentityMap org$beangle$commons$collection$IdentityMap$Entry$$$outer() {
            return this.$outer;
        }
    }

    public class EntryIterator<K, V> {
        private final Entry<K, V>[] table;
        private Entry entry;
        private boolean hasNext;
        private int index;
        private final /* synthetic */ IdentityMap $outer;

        public EntryIterator(IdentityMap $outer, Entry<K, V>[] table) {
            this.table = table;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.hasNext = false;
            this.index = -1;
        }

        public Entry<K, V> entry() {
            return this.entry;
        }

        public void entry_$eq(Entry<K, V> x$1) {
            this.entry = x$1;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public void hasNext_$eq(boolean x$1) {
            this.hasNext = x$1;
        }

        public int index() {
            return this.index;
        }

        public void index_$eq(int x$1) {
            this.index = x$1;
        }

        public void move() {
            if (this.index() < this.table.length) {
                if (this.entry() != null && this.entry().next() != null) {
                    this.entry_$eq(this.entry().next());
                } else {
                    this.entry_$eq(null);
                    this.index_$eq(this.index() + 1);
                    while (this.entry() == null && this.index() < this.table.length) {
                        this.entry_$eq(this.table[this.index()]);
                        this.index_$eq(this.index() + 1);
                    }
                }
            } else {
                this.entry_$eq(null);
            }
            this.hasNext_$eq(this.entry() != null);
        }

        public final /* synthetic */ IdentityMap org$beangle$commons$collection$IdentityMap$EntryIterator$$$outer() {
            return this.$outer;
        }
    }

    public class KeyIterator<K>
    extends EntryIterator<K, V>
    implements Iterator<K> {
        public KeyIterator(Entry<K, V>[] table) {
            if (IdentityMap.this == null) {
                throw new NullPointerException();
            }
            super(IdentityMap.this, table);
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
            this.move();
        }

        public K next() {
            Object key = this.entry().key();
            this.move();
            return key;
        }

        public final /* synthetic */ IdentityMap org$beangle$commons$collection$IdentityMap$KeyIterator$$$outer() {
            return IdentityMap.this;
        }
    }
}

