/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.collection;

import java.io.Serializable;
import org.beangle.commons.collection.Order;
import org.beangle.commons.lang.Strings$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Order$
implements Serializable {
    private static final String OrderStr;
    public static final Order$ MODULE$;

    private Order$() {
    }

    static {
        MODULE$ = new Order$();
        OrderStr = "orderBy";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Order$.class);
    }

    public boolean $lessinit$greater$default$3() {
        return false;
    }

    public String OrderStr() {
        return OrderStr;
    }

    public Order apply(String property) {
        return new Order(property, true, this.$lessinit$greater$default$3());
    }

    public Order apply(String property, boolean ascending) {
        return new Order(property, ascending, this.$lessinit$greater$default$3());
    }

    public Order asc(String property) {
        return new Order(property, true, this.$lessinit$greater$default$3());
    }

    public Order desc(String property) {
        return new Order(property, false, this.$lessinit$greater$default$3());
    }

    public String toSortString(List<Order> orders) {
        if (orders == null || orders.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder("order by ");
        orders.foreach((Function1 & Serializable)order -> {
            if (order.ascending()) {
                return buf.append(order.property()).append(',');
            }
            return buf.append(order.property()).append(" desc,");
        });
        return buf.substring(0, buf.length() - 1).toString();
    }

    public List<Order> parse(String orderString) {
        if (Strings$.MODULE$.isBlank(orderString)) {
            return package$.MODULE$.List().empty();
        }
        ListBuffer orders = new ListBuffer();
        String[] orderStrs = Strings$.MODULE$.split(orderString, ',');
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), orderStrs.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String originOrder = orderStrs[i];
            if (Strings$.MODULE$.isNotBlank(originOrder)) {
                String order = originOrder.toLowerCase();
                if (order.endsWith(" desc")) {
                    orders.$plus$eq((Object)new Order(orderStrs[i].substring(0, order.indexOf(" desc")).trim(), false, MODULE$.$lessinit$greater$default$3()));
                    return;
                }
                if (order.endsWith(" asc")) {
                    orders.$plus$eq((Object)new Order(orderStrs[i].substring(0, order.indexOf(" asc")).trim(), true, MODULE$.$lessinit$greater$default$3()));
                    return;
                }
                if (order.startsWith("-")) {
                    orders.$plus$eq((Object)new Order(orderStrs[i].trim().substring(1), false, MODULE$.$lessinit$greater$default$3()));
                    return;
                }
                orders.$plus$eq((Object)new Order(orderStrs[i].trim(), true, MODULE$.$lessinit$greater$default$3()));
                return;
            }
        });
        return orders.toList();
    }

    public Tuple2<String, Object> org$beangle$commons$collection$Order$$$analysis(String orderStr) {
        if (Strings$.MODULE$.contains((CharSequence)orderStr, ",")) {
            throw new RuntimeException("user parser for multiorder");
        }
        boolean ascending = false;
        String property = orderStr;
        if (Strings$.MODULE$.contains((CharSequence)property, " desc")) {
            ascending = false;
            property = Strings$.MODULE$.substringBefore(property, " desc");
        } else {
            property = Strings$.MODULE$.contains((CharSequence)property, " asc") ? Strings$.MODULE$.substringBefore(property, " asc") : property;
            ascending = true;
        }
        property = property.trim();
        return Tuple2$.MODULE$.apply((Object)property, (Object)BoxesRunTime.boxToBoolean((boolean)ascending));
    }
}

