/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.collection.page;

import org.beangle.commons.collection.page.Page;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.collection.page.PageLimit$;
import org.beangle.commons.collection.page.PagedSeq$;
import org.beangle.commons.collection.page.SinglePage;
import scala.PartialFunction;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Iterable;

public class PagedSeq<E>
implements Page<E> {
    private final scala.collection.immutable.Seq datas;
    private Page page;
    private int pageIndex;
    private final int totalPages;
    private final int pageSize;

    public PagedSeq(scala.collection.immutable.Seq<E> datas, PageLimit limit) {
        this.datas = datas;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        scala.collection.Iterable.$init$((scala.collection.Iterable)this);
        Iterable.$init$((Iterable)this);
        PartialFunction.$init$((PartialFunction)this);
        SeqOps.$init$((SeqOps)this);
        Seq.$init$((Seq)this);
        scala.collection.immutable.Seq.$init$((scala.collection.immutable.Seq)this);
        this.pageIndex = limit.pageIndex() - 1;
        this.totalPages = PagedSeq$.MODULE$.org$beangle$commons$collection$page$PagedSeq$$$calcMaxPageNo(datas.size(), limit.pageSize());
        this.pageSize = limit.pageSize();
        this.next();
    }

    public <B> scala.collection.immutable.Seq<B> scala$collection$SeqOps$$super$concat(IterableOnce<B> suffix) {
        return (scala.collection.immutable.Seq)IterableOps.concat$((IterableOps)this, suffix);
    }

    public int scala$collection$SeqOps$$super$sizeCompare(int otherSize) {
        return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
    }

    public int scala$collection$SeqOps$$super$sizeCompare(scala.collection.Iterable<?> that) {
        return IterableOps.sizeCompare$((IterableOps)this, that);
    }

    public scala.collection.immutable.Seq<E> datas() {
        return this.datas;
    }

    public Page<E> page() {
        return this.page;
    }

    public void page_$eq(Page<E> x$1) {
        this.page = x$1;
    }

    @Override
    public int pageIndex() {
        return this.pageIndex;
    }

    public void pageIndex_$eq(int x$1) {
        this.pageIndex = x$1;
    }

    @Override
    public int totalPages() {
        return this.totalPages;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    public PagedSeq(scala.collection.immutable.Seq<E> datas, int pageSize) {
        this(datas, PageLimit$.MODULE$.apply(1, pageSize));
    }

    @Override
    public Seq<E> items() {
        return this.page().items();
    }

    public Iterator<E> iterator() {
        return this.page().iterator();
    }

    public int length() {
        return this.page().length();
    }

    public E apply(int index) {
        return (E)this.page().apply(index);
    }

    @Override
    public int totalItems() {
        return this.datas().size();
    }

    @Override
    public boolean hasNext() {
        return this.pageIndex() < this.totalPages();
    }

    @Override
    public boolean hasPrevious() {
        return this.pageIndex() > 1;
    }

    @Override
    public Page<E> next() {
        return this.moveTo(this.pageIndex() + 1);
    }

    @Override
    public Page<E> previous() {
        return this.moveTo(this.pageIndex() - 1);
    }

    @Override
    public Page<E> moveTo(int pageIndex) {
        if (pageIndex < 1) {
            throw new RuntimeException("error pageIndex:" + pageIndex);
        }
        this.pageIndex_$eq(pageIndex);
        int toIndex = pageIndex * this.pageSize();
        SinglePage newPage = new SinglePage(pageIndex, this.pageSize(), this.datas().size(), (Seq)this.datas().slice((pageIndex - 1) * this.pageSize(), toIndex < this.datas().size() ? toIndex : this.datas().size()));
        this.page_$eq(newPage);
        return this;
    }
}

