/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.collection.page;

import org.beangle.commons.collection.page.Page;
import scala.PartialFunction;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Iterable;

public class SinglePage<E>
implements Page<E> {
    private final int pageIndex;
    private final int pageSize;
    private final int totalItems;
    private final Seq items;

    public SinglePage(int pageIndex, int pageSize, int totalItems, Seq<E> items) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.totalItems = totalItems;
        this.items = items;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        scala.collection.Iterable.$init$((scala.collection.Iterable)this);
        Iterable.$init$((Iterable)this);
        PartialFunction.$init$((PartialFunction)this);
        SeqOps.$init$((SeqOps)this);
        Seq.$init$((Seq)this);
        scala.collection.immutable.Seq.$init$((scala.collection.immutable.Seq)this);
    }

    public <B> scala.collection.immutable.Seq<B> scala$collection$SeqOps$$super$concat(IterableOnce<B> suffix) {
        return (scala.collection.immutable.Seq)IterableOps.concat$((IterableOps)this, suffix);
    }

    public int scala$collection$SeqOps$$super$sizeCompare(int otherSize) {
        return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
    }

    public int scala$collection$SeqOps$$super$sizeCompare(scala.collection.Iterable<?> that) {
        return IterableOps.sizeCompare$((IterableOps)this, that);
    }

    @Override
    public int pageIndex() {
        return this.pageIndex;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public int totalItems() {
        return this.totalItems;
    }

    @Override
    public Seq<E> items() {
        return this.items;
    }

    @Override
    public int totalPages() {
        if (this.totalItems() < this.pageSize()) {
            return 1;
        }
        int remainder = this.totalItems() % this.pageSize();
        int quotient = this.totalItems() / this.pageSize();
        if (0 == remainder) {
            return quotient;
        }
        return quotient + 1;
    }

    @Override
    public boolean hasNext() {
        return this.totalPages() > this.pageIndex();
    }

    @Override
    public boolean hasPrevious() {
        return this.pageIndex() > 1;
    }

    @Override
    public Page<E> next() {
        return this;
    }

    @Override
    public Page<E> previous() {
        return this;
    }

    @Override
    public Page<E> moveTo(int pageIndex) {
        return this;
    }

    public E apply(int index) {
        return (E)this.items().apply(index);
    }

    public int length() {
        return this.items().size();
    }

    public Iterator<E> iterator() {
        return this.items().iterator();
    }
}

