/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.config.property;

import java.io.Serializable;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.config.property.PropertyConfig;
import org.beangle.commons.config.property.PropertyConfigEvent;
import org.beangle.commons.config.property.PropertyConfigListener;
import org.beangle.commons.conversion.impl.DefaultConversion$;
import org.beangle.commons.conversion.string.BooleanConverter$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.function.JProcedure1;

public class MultiProviderPropertyConfig
implements PropertyConfig,
Initializing {
    private HashMap<String, Object> properties = new HashMap();
    private ListBuffer<PropertyConfigListener> listeners = new ListBuffer();
    private ListBuffer<PropertyConfig.Provider> providers = new ListBuffer();

    @Override
    public void init() {
        this.reload();
    }

    @Override
    public Option<Object> get(String name) {
        return this.properties.get((Object)name);
    }

    @Override
    public void set(String name, Object value2) {
        this.properties.put((Object)name, value2);
    }

    @Override
    public <T> Option<T> get(Class<T> clazz, String name) {
        Option<Object> option = this.get(name);
        if (option instanceof Some) {
            Object value2 = ((Some)option).value();
            if (value2 == null) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply(DefaultConversion$.MODULE$.Instance().convert(value2, clazz));
        }
        return None$.MODULE$;
    }

    public Option<Object> getInt(String name) {
        Option<Object> option = this.get(name);
        if (option instanceof Some) {
            Object value2 = ((Some)option).value();
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Numbers$.MODULE$.toInt((String)value2, Numbers$.MODULE$.toInt$default$2())));
        }
        return None$.MODULE$;
    }

    public Option<Object> getBoolean(String name) {
        Option<Object> option = this.get(name);
        if (option instanceof Some) {
            Object value2 = ((Some)option).value();
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(BooleanConverter$.MODULE$.apply((String)value2))));
        }
        return None$.MODULE$;
    }

    @Override
    public void add(Map<String, Object> newer) {
        this.properties.$plus$plus$eq(newer);
    }

    @Override
    public void addListener(PropertyConfigListener listener) {
        this.listeners.$plus$eq((Object)listener);
    }

    @Override
    public void removeListener(PropertyConfigListener listener) {
        this.listeners.$minus$eq((Object)listener);
    }

    @Override
    public void multicast() {
        PropertyConfigEvent e = new PropertyConfigEvent(this);
        this.listeners.foreach((Function1)(JProcedure1 & Serializable)listener -> listener.onConfigEvent(e));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultSystemConfig[");
        List props = this.properties.keySet().toList();
        IntRef maxlength = IntRef.create((int)0);
        props.withFilter((Function1 & Serializable)property -> property.length() > maxlength$1.elem).foreach((Function1)(JProcedure1 & Serializable)property -> {
            maxlength$2.elem = property.length();
        });
        props.foreach((Function1 & Serializable)property -> {
            sb.append('\n').append(property);
            sb.append(Strings$.MODULE$.repeat(" ", maxlength$3.elem - property.length()));
            return sb.append('=').append((Object)this.properties.get(property));
        });
        sb.append("\n]");
        return sb.toString();
    }

    @Override
    public Set<String> names() {
        return this.properties.keySet().toSet();
    }

    @Override
    public void addProvider(PropertyConfig.Provider provider) {
        this.providers.$plus$eq((Object)provider);
    }

    @Override
    public void reload() {
        MultiProviderPropertyConfig multiProviderPropertyConfig = this;
        synchronized (multiProviderPropertyConfig) {
            this.providers.foreach((Function1)(JProcedure1 & Serializable)provider -> this.add(provider.getConfig()));
            this.multicast();
        }
    }

    public void setProviders(List<PropertyConfig.Provider> providers) {
        this.providers.clear();
        this.providers.$plus$plus$eq(providers);
    }
}

