/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.conversion.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.beangle.commons.conversion.Conversion;
import org.beangle.commons.conversion.Converter;
import org.beangle.commons.conversion.ConverterRegistry;
import org.beangle.commons.conversion.converter.CtorConverter;
import org.beangle.commons.conversion.converter.MethodConverter;
import org.beangle.commons.conversion.impl.ConverterAdapter;
import org.beangle.commons.conversion.impl.GenericConverter;
import org.beangle.commons.conversion.impl.NoneConverter$;
import org.beangle.commons.lang.Companions$;
import org.beangle.commons.lang.Objects$;
import org.beangle.commons.lang.Primitives$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.Set;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public abstract class AbstractGenericConversion
implements Conversion,
ConverterRegistry {
    private final HashMap converters = new HashMap();
    private final TrieMap cache = new TrieMap();

    public HashMap<Class<?>, Map<Class<?>, GenericConverter>> converters() {
        return this.converters;
    }

    public TrieMap<Tuple2<Class<?>, Class<?>>, GenericConverter> cache() {
        return this.cache;
    }

    @Override
    public <T> T convert(Object source, Class<T> target) {
        if (source == null) {
            return Objects$.MODULE$.default(target);
        }
        Class<?> sourceClazz = Primitives$.MODULE$.wrap(source.getClass());
        Class<T> targetClazz = Primitives$.MODULE$.wrap(target);
        if (targetClazz.isAssignableFrom(sourceClazz)) {
            return (T)source;
        }
        if (sourceClazz.isArray() && targetClazz.isArray()) {
            Class<?> targetObjClazz;
            Class<?> targetObjType;
            Class<?> sourceObjType = Primitives$.MODULE$.wrap(sourceClazz.getComponentType());
            GenericConverter converter = this.findConverter(sourceObjType, targetObjType = Primitives$.MODULE$.wrap(targetObjClazz = targetClazz.getComponentType()));
            if (converter == null) {
                return (T)Array.newInstance(targetObjClazz, 0);
            }
            int length = Array.getLength(source);
            Object result = Array.newInstance(targetObjClazz, length);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> Array.set(result, i, converter.convert(Array.get(source, i), targetObjType)));
            return (T)result;
        }
        GenericConverter converter = this.findConverter(sourceClazz, targetClazz);
        T rs = converter.convert(source, targetClazz);
        if (rs == null && target.isPrimitive()) {
            return Objects$.MODULE$.default(target);
        }
        return rs;
    }

    @Override
    public void addConverter(Converter<?, ?> converter) {
        ObjectRef key = ObjectRef.create(null);
        Object object = Predef$.MODULE$.refArrayOps((Object[])converter.getClass().getMethods());
        ArrayOps$.MODULE$.withFilter$extension(object, (Function1 & Serializable)m -> {
            String string = m.getName();
            String string2 = "apply";
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!Modifier.isPublic(m.getModifiers())) return false;
            if (m.isBridge()) return false;
            return true;
        }).foreach((Function1)(JProcedure1 & Serializable)m -> {
            key$1.elem = Tuple2$.MODULE$.apply(m.getParameterTypes()[0], m.getReturnType());
        });
        if ((Tuple2)key.elem == null) {
            throw new IllegalArgumentException("Cannot find convert type pair " + converter.getClass());
        }
        Class sourceType = (Class)((Tuple2)key.elem)._1();
        ConverterAdapter adapter = new ConverterAdapter(converter, (Tuple2)key.elem);
        Option option = this.converters().get((Object)sourceType);
        if (option instanceof Some) {
            Map existed = (Map)((Some)option).value();
            Class clazz = (Class)Predef$.MODULE$.ArrowAssoc((Object)sourceType);
            Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc((Object)((Class)((Tuple2)key.elem)._2()));
            v0 = (HashMap)this.converters().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)existed.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)adapter))));
        } else {
            Class clazz = (Class)Predef$.MODULE$.ArrowAssoc((Object)sourceType);
            Object[] objectArray = new Tuple2[1];
            Class clazz3 = (Class)Predef$.MODULE$.ArrowAssoc((Object)((Class)((Tuple2)key.elem)._2()));
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz3, (Object)adapter);
            v0 = (HashMap)this.converters().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        }
        this.cache().clear();
    }

    public void addConverter(GenericConverter converter) {
        Tuple2<Class<?>, Class<?>> key = converter.getTypeinfo();
        Class sourceType = (Class)key._1();
        Option option = this.converters().get((Object)sourceType);
        if (option instanceof Some) {
            Map existed = (Map)((Some)option).value();
            Class clazz = (Class)Predef$.MODULE$.ArrowAssoc((Object)((Class)key._1()));
            Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc((Object)((Class)key._2()));
            v0 = (HashMap)this.converters().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)existed.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)converter))));
        } else {
            Class clazz = (Class)Predef$.MODULE$.ArrowAssoc((Object)((Class)key._1()));
            Object[] objectArray = new Tuple2[1];
            Class clazz3 = (Class)Predef$.MODULE$.ArrowAssoc((Object)((Class)key._2()));
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz3, (Object)converter);
            v0 = (HashMap)this.converters().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        }
        this.cache().clear();
    }

    public GenericConverter findConverter(Class<?> sourceType, Class<?> targetType) {
        Tuple2 key = Tuple2$.MODULE$.apply(sourceType, targetType);
        GenericConverter converter = (GenericConverter)this.cache().get((Object)key).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (converter == null) {
            converter = this.searchConverter(sourceType, targetType);
            if (converter == null) {
                converter = this.findCtorConverter(sourceType, targetType);
            }
            if (converter == null) {
                converter = NoneConverter$.MODULE$;
            }
            this.cache().put((Object)key, (Object)converter);
        }
        return converter;
    }

    public GenericConverter findCtorConverter(Class<?> sourceType, Class<?> targetType) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])targetType.getConstructors());
        Option ctor = ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)c -> {
            Object object;
            Object[] pts = c.getParameterTypes();
            return pts.length == 1 && ArrayOps$.MODULE$.contains$extension(object = Predef$.MODULE$.refArrayOps(pts), (Object)sourceType);
        });
        Option option = ctor;
        if (None$.MODULE$.equals(option)) {
            Option<Object> option2 = Companions$.MODULE$.getCompanion(targetType);
            if (None$.MODULE$.equals(option2)) {
                return null;
            }
            if (option2 instanceof Some) {
                MethodConverter methodConverter;
                Object ct = ((Some)option2).value();
                try {
                    MethodConverter nc = new MethodConverter(sourceType, targetType, ct, ct.getClass().getDeclaredMethod("apply", sourceType));
                    this.addConverter(nc);
                    methodConverter = nc;
                }
                catch (Exception e) {
                    methodConverter = null;
                }
                return methodConverter;
            }
            throw new MatchError(option2);
        }
        if (option instanceof Some) {
            Constructor ct = (Constructor)((Some)option).value();
            CtorConverter nc = new CtorConverter(sourceType, targetType, ct);
            this.addConverter(nc);
            return nc;
        }
        throw new MatchError((Object)option);
    }

    public GenericConverter searchConverter(Class<?> sourceType, Class<?> targetType) {
        LinkedHashSet interfaces = new LinkedHashSet();
        Queue classQueue = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        classQueue.$plus$eq(sourceType);
        while (classQueue.nonEmpty()) {
            Class currentClass = (Class)classQueue.dequeue();
            GenericConverter converter = this.getConverter(targetType, this.getConverters(currentClass));
            if (converter != null) {
                return converter;
            }
            Class superClass = currentClass.getSuperclass();
            if (superClass != null) {
                Class clazz = superClass;
                Class<Object> clazz2 = Object.class;
                if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
                    classQueue.$plus$eq(superClass);
                }
            }
            Object object = Predef$.MODULE$.refArrayOps((Object[])currentClass.getInterfaces());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)interfaceType -> this.addInterfaces((Class<?>)interfaceType, (Set<Class<?>>)interfaces));
        }
        for (Class interfaceType2 : interfaces) {
            GenericConverter converter = this.getConverter(targetType, this.getConverters(interfaceType2));
            if (converter == null) continue;
            return converter;
        }
        return this.getConverter(targetType, this.getConverters(Object.class));
    }

    private Map<Class<?>, GenericConverter> getConverters(Class<?> sourceType) {
        return (Map)this.converters().getOrElse(sourceType, AbstractGenericConversion::getConverters$$anonfun$1);
    }

    private GenericConverter getConverter(Class<?> targetType, Map<Class<?>, GenericConverter> converters) {
        LinkedHashSet interfaces = new LinkedHashSet();
        Queue queue = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        queue.$plus$eq(targetType);
        while (queue.nonEmpty()) {
            Class cur = (Class)queue.dequeue();
            GenericConverter converter = (GenericConverter)converters.get((Object)cur).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (converter != null) {
                return converter;
            }
            Class superClass = cur.getSuperclass();
            if (superClass != null) {
                Class clazz = superClass;
                Class<Object> clazz2 = Object.class;
                if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
                    queue.$plus$eq(superClass);
                }
            }
            Object object = Predef$.MODULE$.refArrayOps((Object[])cur.getInterfaces());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)interfaceType -> this.addInterfaces((Class<?>)interfaceType, (Set<Class<?>>)interfaces));
        }
        for (Class interfaceType2 : interfaces) {
            GenericConverter converter = (GenericConverter)converters.get((Object)interfaceType2).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (converter == null) continue;
            return converter;
        }
        return null;
    }

    private void addInterfaces(Class<?> interfaceType, Set<Class<?>> interfaces) {
        interfaces.add(interfaceType);
        Object object = Predef$.MODULE$.refArrayOps((Object[])interfaceType.getInterfaces());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)inheritedInterface -> this.addInterfaces((Class<?>)inheritedInterface, interfaces));
    }

    private static final Map getConverters$$anonfun$1() {
        return Predef$.MODULE$.Map().empty();
    }
}

