/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.beangle.commons.csv.CsvFormat;
import org.beangle.commons.csv.CsvWriter$;
import org.beangle.commons.lang.Throwables$;
import scala.Char$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class CsvWriter
implements Closeable {
    private final Writer writer;
    private final CsvFormat format;
    private String lineEnd;

    public static String DefaultLineEnd() {
        return CsvWriter$.MODULE$.DefaultLineEnd();
    }

    public static int InitialStringSize() {
        return CsvWriter$.MODULE$.InitialStringSize();
    }

    public static char NoEscapeChar() {
        return CsvWriter$.MODULE$.NoEscapeChar();
    }

    public static char NoQuoteChar() {
        return CsvWriter$.MODULE$.NoQuoteChar();
    }

    public static CsvFormat $lessinit$greater$default$2() {
        return CsvWriter$.MODULE$.$lessinit$greater$default$2();
    }

    public CsvWriter(Writer writer, CsvFormat format) {
        this.writer = writer;
        this.format = format;
        this.lineEnd = "\n";
    }

    public Writer writer() {
        return this.writer;
    }

    public CsvFormat format() {
        return this.format;
    }

    public void write(Object data) {
        Object object = data;
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object a = object;
            this.writeOne(a);
            return;
        }
        if (object instanceof Iterable) {
            Iterable lines = (Iterable)object;
            lines.foreach((Function1)(JProcedure1 & Serializable)line -> this.writeOne(line));
            return;
        }
        throw new MatchError(object);
    }

    private void writeOne(Object nextLine) {
        if (nextLine == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(CsvWriter$.MODULE$.InitialStringSize());
        Object object = Predef$.MODULE$.genericArrayOps(nextLine);
        ArrayOps$.MODULE$.indices$extension(object).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Object nextElem;
            if (i != 0) {
                sb.append(this.format().defaultSeparator());
            }
            if ((nextElem = ScalaRunTime$.MODULE$.array_apply(nextLine, i)) != null) {
                String nextElement = nextElem.toString();
                if (!this.format().isDelimiter(CsvWriter$.MODULE$.NoQuoteChar())) {
                    sb.append(this.format().delimiter());
                }
                sb.append((CharSequence)(this.containsSpecialChar(nextElement) ? this.processLine(nextElement) : nextElement));
                if (!this.format().isDelimiter(CsvWriter$.MODULE$.NoQuoteChar())) {
                    sb.append(this.format().delimiter());
                    return;
                }
                return;
            }
        });
        sb.append(this.lineEnd);
        this.writer().write(sb.toString());
    }

    private boolean containsSpecialChar(String line) {
        return line.indexOf(Char$.MODULE$.char2int(this.format().delimiter())) != -1 || line.indexOf(Char$.MODULE$.char2int(this.format().delimiter())) != -1;
    }

    public StringBuilder processLine(String nextElement) {
        StringBuilder sb = new StringBuilder(CsvWriter$.MODULE$.InitialStringSize());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nextElement.length()).foreach((Function1 & Serializable)j -> this.processLine$$anonfun$1(nextElement, sb, BoxesRunTime.unboxToInt((Object)j)));
        return sb;
    }

    public void flush() {
        this.writer().flush();
    }

    @Override
    public void close() {
        try {
            this.flush();
            this.writer().close();
        }
        catch (IOException e) {
            Throwables$.MODULE$.propagate(e);
        }
    }

    private final /* synthetic */ StringBuilder processLine$$anonfun$1(String nextElement$1, StringBuilder sb$2, int j) {
        char nextChar = nextElement$1.charAt(j);
        if (this.format().escape() != CsvWriter$.MODULE$.NoEscapeChar() && nextChar == this.format().delimiter()) {
            return sb$2.append(this.format().escape()).append(nextChar);
        }
        if (this.format().escape() != CsvWriter$.MODULE$.NoEscapeChar() && nextChar == this.format().escape()) {
            return sb$2.append(this.format().escape()).append(nextChar);
        }
        return sb$2.append(nextChar);
    }
}

