/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.file.diff.bsdiff;

import java.io.Serializable;
import org.beangle.commons.file.diff.bsdiff.SuffixSort;
import org.beangle.commons.file.diff.bsdiff.SuffixSort$SearchResult$;
import scala.runtime.ModuleSerializationProxy;

public final class SuffixSort$
implements Serializable {
    public static final SuffixSort$SearchResult$ SearchResult;
    public static final SuffixSort$ MODULE$;

    private SuffixSort$() {
    }

    static {
        MODULE$ = new SuffixSort$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SuffixSort$.class);
    }

    public void qsufsort(int[] I, int[] V, byte[] data) {
        int i;
        int[] buckets = new int[256];
        for (i = 0; i < data.length; ++i) {
            int n = data[i] & 0xFF;
            buckets[n] = buckets[n] + 1;
        }
        for (i = 1; i < 256; ++i) {
            int n = i;
            buckets[n] = buckets[n] + buckets[i - 1];
        }
        for (i = 255; i > 0; --i) {
            buckets[i] = buckets[i - 1];
        }
        buckets[0] = 0;
        i = 0;
        while (i < data.length) {
            int idx = data[i] & 0xFF;
            buckets[idx] = buckets[idx] + 1;
            I[buckets[idx]] = i++;
        }
        I[0] = data.length;
        for (i = 0; i < data.length; ++i) {
            V[i] = buckets[data[i] & 0xFF];
        }
        V[data.length] = 0;
        for (i = 1; i < 256; ++i) {
            if (buckets[i] != buckets[i - 1] + 1) continue;
            I[buckets[i]] = -1;
        }
        I[0] = -1;
        int h = 1;
        int len = 0;
        while (I[0] != -(data.length + 1)) {
            len = 0;
            i = 0;
            while (i < data.length + 1) {
                if (I[i] < 0) {
                    len -= I[i];
                    i -= I[i];
                    continue;
                }
                if (len != 0) {
                    I[i - len] = -len;
                }
                len = V[I[i]] + 1 - i;
                this.split(I, V, i, len, h);
                i += len;
                len = 0;
            }
            if (len != 0) {
                I[i - len] = -len;
            }
            h += h;
        }
        for (i = 0; i < data.length + 1; ++i) {
            I[V[i]] = i;
        }
    }

    public void split(int[] I, int[] V, int start, int len, int h) {
        while (true) {
            int i = 0;
            int j = 0;
            int k = 0;
            int x = 0;
            int tmp = 0;
            int jj = 0;
            int kk = 0;
            if (len < 16) {
                for (k = start; k < start + len; k += j) {
                    j = 1;
                    x = V[I[k] + h];
                    i = 1;
                    while (k + i < start + len) {
                        if (V[I[k + i] + h] < x) {
                            x = V[I[k + i] + h];
                            j = 0;
                        }
                        if (V[I[k + i] + h] == x) {
                            tmp = I[k + j];
                            I[k + j] = I[k + i];
                            I[k + i] = tmp;
                            ++j;
                        }
                        ++i;
                    }
                    for (i = 0; i < j; ++i) {
                        V[I[k + i]] = k + j - 1;
                    }
                    if (j != 1) continue;
                    I[k] = -1;
                }
                return;
            }
            x = V[I[start + len / 2] + h];
            jj = 0;
            kk = 0;
            for (i = start; i < start + len; ++i) {
                if (V[I[i] + h] < x) {
                    ++jj;
                }
                if (V[I[i] + h] != x) continue;
                ++kk;
            }
            kk += (jj += start);
            i = start;
            j = 0;
            k = 0;
            while (i < jj) {
                if (V[I[i] + h] < x) {
                    ++i;
                    continue;
                }
                if (V[I[i] + h] == x) {
                    tmp = I[i];
                    I[i] = I[jj + j];
                    I[jj + j] = tmp;
                    ++j;
                    continue;
                }
                tmp = I[i];
                I[i] = I[kk + k];
                I[kk + k] = tmp;
                ++k;
            }
            while (jj + j < kk) {
                if (V[I[jj + j] + h] == x) {
                    ++j;
                    continue;
                }
                tmp = I[jj + j];
                I[jj + j] = I[kk + k];
                I[kk + k] = tmp;
                ++k;
            }
            if (jj > start) {
                this.split(I, V, start, jj - start, h);
            }
            for (i = 0; i < kk - jj; ++i) {
                V[I[jj + i]] = kk - 1;
            }
            if (jj == kk - 1) {
                I[jj] = -1;
            }
            if (start + len <= kk) break;
            int n = kk;
            int n2 = start + len - kk;
            start = n;
            len = n2;
        }
    }

    public SuffixSort.SearchResult search(int[] I, byte[] oldBytes, int oldOffset, byte[] newBytes, int newOffset, int start, int end) {
        while (true) {
            if (end - start < 2) {
                int y;
                int x = this.matchlen(oldBytes, I[start], newBytes, newOffset);
                if (x > (y = this.matchlen(oldBytes, I[end], newBytes, newOffset))) {
                    return SuffixSort$SearchResult$.MODULE$.apply(x, I[start]);
                }
                return SuffixSort$SearchResult$.MODULE$.apply(y, I[end]);
            }
            int center = start + (end - start) / 2;
            if (this.compareBytes(oldBytes, I[center], newBytes, newOffset) < 0) {
                int n = 0;
                int n2 = center;
                oldOffset = n;
                start = n2;
                continue;
            }
            int n = 0;
            int n3 = center;
            oldOffset = n;
            end = n3;
        }
    }

    private int matchlen(byte[] bytesA, int offsetA, byte[] bytesB, int offsetB) {
        int i;
        int oldLimit = bytesA.length - offsetA;
        int newLimit = bytesB.length - offsetB;
        for (i = 0; i < oldLimit && i < newLimit && bytesA[i + offsetA] == bytesB[i + offsetB]; ++i) {
        }
        return i;
    }

    private int compareBytes(byte[] bytesA, int offsetA, byte[] bytesB, int offsetB) {
        int length = Math.min(bytesA.length - offsetA, bytesB.length - offsetB);
        int valA = 0;
        int valB = 0;
        for (int i = 0; i < length && valA == valB; ++i) {
            valA = bytesA[i + offsetA] & 0xFF;
            valB = bytesB[i + offsetB] & 0xFF;
        }
        return valA - valB;
    }
}

