/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.beangle.commons.io.BinarySerializer;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.io.ObjectSerializer;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public abstract class AbstractBinarySerializer
implements BinarySerializer {
    private Map<Class<?>, ObjectSerializer> serializers = Predef$.MODULE$.Map().empty();

    public void register(Class<?> clazz, ObjectSerializer os) {
        Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(clazz);
        this.serializers = (Map)this.serializers.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)os));
    }

    @Override
    public void serialize(Object data, OutputStream os, Map<String, Object> params) {
        if (data != null) {
            Option option = this.serializers.get(data.getClass());
            if (option instanceof Some) {
                ObjectSerializer serializer = (ObjectSerializer)((Some)option).value();
                serializer.serialize(data, os, params);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                throw new RuntimeException("Cannot find " + data.getClass().getName() + "'s corresponding ObjectSerializer.");
            }
            throw new MatchError((Object)option);
        }
    }

    @Override
    public <T> T deserialize(Class<T> clazz, InputStream is, Map<String, Object> params) {
        Option option = this.serializers.get(clazz);
        if (option instanceof Some) {
            ObjectSerializer serializer = (ObjectSerializer)((Some)option).value();
            Object rs = serializer.deserialize(is, params);
            IOs$.MODULE$.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{is}));
            return (T)rs;
        }
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException("Cannot find " + clazz.getName() + "'s ObjectSerializer.");
        }
        throw new MatchError((Object)option);
    }

    @Override
    public byte[] asBytes(Object data) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.serialize(data, os, (Map<String, Object>)Predef$.MODULE$.Map().empty());
        return os.toByteArray();
    }

    @Override
    public <T> T asObject(Class<T> clazz, byte[] data) {
        return this.deserialize(clazz, new ByteArrayInputStream(data), (Map<String, Object>)Predef$.MODULE$.Map().empty());
    }
}

