/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.io;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import org.beangle.commons.io.Dirs;
import scala.runtime.ModuleSerializationProxy;

public final class Dirs$
implements Serializable {
    public static final Dirs$ MODULE$ = new Dirs$();

    private Dirs$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Dirs$.class);
    }

    public Dirs on(String path) {
        return new Dirs(new File(path));
    }

    public Dirs on(File file) {
        return new Dirs(file);
    }

    public Dirs on(File file, String child) {
        return new Dirs(new File(file, child));
    }

    public void delete(File file) {
        if (this.isLink(file)) {
            file.delete();
            return;
        }
        if (file.exists()) {
            this.remove(file);
            return;
        }
    }

    public boolean isLink(File file) {
        return Files.isSymbolicLink(file.toPath());
    }

    private void remove(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                if (file.list().length == 0 || this.isLink(file)) {
                    file.delete();
                    return;
                }
                String[] files = file.list();
                for (int i = 0; i < files.length; ++i) {
                    String tmp = files[i];
                    this.remove(new File(file, tmp));
                }
                if (file.list().length == 0) {
                    file.delete();
                    return;
                }
                return;
            }
            file.delete();
            return;
        }
    }
}

