/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.io;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.beangle.commons.io.Dirs$;
import org.beangle.commons.io.Files$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class Dirs {
    private final File pwd;

    public static boolean isLink(File file) {
        return Dirs$.MODULE$.isLink(file);
    }

    public static Dirs on(File file) {
        return Dirs$.MODULE$.on(file);
    }

    public static Dirs on(File file, String string) {
        return Dirs$.MODULE$.on(file, string);
    }

    public static Dirs on(String string) {
        return Dirs$.MODULE$.on(string);
    }

    public Dirs(File pwd) {
        this.pwd = pwd;
        Predef$.MODULE$.require(!pwd.exists() || pwd.isDirectory());
    }

    public File pwd() {
        return this.pwd;
    }

    public boolean exists() {
        return this.pwd().exists();
    }

    public Dirs rename(String newName) {
        File dest = new File(this.pwd().getParentFile().getAbsolutePath() + Files$.MODULE$.$div() + newName);
        this.pwd().renameTo(dest);
        return new Dirs(dest);
    }

    public Dirs delete(Seq<String> children) {
        children.foreach((Function1)(JProcedure1 & Serializable)child -> Dirs$.MODULE$.delete(new File(this.pwd(), (String)child)));
        return this;
    }

    public Dirs mkdirs(Seq<String> children) {
        if (children.isEmpty()) {
            v0 = BoxesRunTime.boxToBoolean((boolean)this.pwd().mkdirs());
        } else {
            children.foreach((Function1 & Serializable)child -> new File(this.pwd(), (String)child).mkdirs());
            v0 = BoxedUnit.UNIT;
        }
        return this;
    }

    public Seq<String> ls() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.pwd().list());
        return ArrayOps$.MODULE$.toSeq$extension(object);
    }

    public Dirs cd(String child) {
        return new Dirs(new File(this.pwd(), child));
    }

    public Dirs touch(String child) {
        File file = new File(this.pwd(), child);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            Files$.MODULE$.touch(file);
        }
        return this;
    }

    public Dirs ln(String target) {
        return this.ln(new File(target));
    }

    public Dirs ln(File target) {
        return this.ln(target, target.getName());
    }

    public Dirs setReadOnly() {
        Files$.MODULE$.setReadOnly(this.pwd());
        return this;
    }

    public Dirs setWriteable() {
        Files$.MODULE$.setWriteable(this.pwd());
        return this;
    }

    public Dirs ln(File target, String newName) {
        if (!target.exists()) {
            throw new RuntimeException("Cannot find target " + target.getAbsolutePath());
        }
        File link = new File(this.pwd(), newName);
        if (Files.isSymbolicLink(Paths.get(link.toURI()))) {
            link.delete();
        }
        if (link.exists()) {
            throw new RuntimeException("Cannot make link on existed file.");
        }
        Files.createSymbolicLink(Paths.get(link.toURI()), Paths.get(target.toURI()), new FileAttribute[0]);
        return this;
    }

    public Dirs write(String fileName, String content) {
        this.touch(fileName);
        Files$.MODULE$.writeString(new File(this.pwd(), fileName), content, Files$.MODULE$.writeString$default$3());
        return this;
    }

    public Dirs copyFrom(String file) {
        File src = new File(file);
        Files$.MODULE$.copy(src, new File(this.pwd(), src.getName()));
        return this;
    }
}

