/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.io;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.beangle.commons.io.Jars$;
import org.beangle.commons.io.ResourceLoader;
import org.beangle.commons.io.ResourcePatternResolver$;
import org.beangle.commons.io.ResourceResolver;
import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.net.Networks$;
import org.beangle.commons.regex.AntPathPattern;
import org.beangle.commons.regex.AntPathPattern$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.mutable.LinkedHashSet;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class ResourcePatternResolver
implements ResourceResolver {
    private String ClasspathAllUrlPrefix;
    private String ClasspathUrlPrefix;
    private final ResourceLoader loader;
    private final Method equinoxResolveMethod;

    public static ResourceLoader $lessinit$greater$default$1() {
        return ResourcePatternResolver$.MODULE$.$lessinit$greater$default$1();
    }

    public ResourcePatternResolver(ResourceLoader loader) {
        Method method;
        this.loader = loader;
        ResourceResolver.$init$(this);
        ResourcePatternResolver resourcePatternResolver = this;
        try {
            method = ClassLoaders$.MODULE$.load("org.eclipse.core.runtime.FileLocator", ClassLoaders$.MODULE$.load$default$2()).getMethod("resolve", URL.class);
        }
        catch (Throwable throwable) {
            method = null;
        }
        Method method2 = method;
        ResourcePatternResolver resourcePatternResolver2 = resourcePatternResolver;
        resourcePatternResolver = null;
        Method method3 = method2;
        method2 = null;
        resourcePatternResolver2.equinoxResolveMethod = method3;
        Statics.releaseFence();
    }

    @Override
    public String ClasspathAllUrlPrefix() {
        return this.ClasspathAllUrlPrefix;
    }

    @Override
    public String ClasspathUrlPrefix() {
        return this.ClasspathUrlPrefix;
    }

    @Override
    public void org$beangle$commons$io$ResourceResolver$_setter_$ClasspathAllUrlPrefix_$eq(String x$0) {
        this.ClasspathAllUrlPrefix = x$0;
    }

    @Override
    public void org$beangle$commons$io$ResourceResolver$_setter_$ClasspathUrlPrefix_$eq(String x$0) {
        this.ClasspathUrlPrefix = x$0;
    }

    public ResourceLoader loader() {
        return this.loader;
    }

    @Override
    public List<URL> getResources(String locationPattern) {
        String location;
        String string = location = locationPattern.startsWith(this.ClasspathAllUrlPrefix()) || locationPattern.startsWith(this.ClasspathUrlPrefix()) ? Strings$.MODULE$.substringAfter(locationPattern, ":") : locationPattern;
        if (AntPathPattern$.MODULE$.isPattern(location)) {
            String rootDirPath = this.determineRootDir(locationPattern);
            AntPathPattern subPattern = new AntPathPattern(locationPattern.substring(rootDirPath.length()));
            List<URL> rootDirResources = this.getResources(rootDirPath);
            LinkedHashSet result = new LinkedHashSet();
            rootDirResources.foreach((Function1 & Serializable)rootDir -> {
                URL rootUrl = this.resolve((URL)rootDir);
                if (Jars$.MODULE$.isJarURL(rootUrl)) {
                    return (LinkedHashSet)result.$plus$plus$eq(this.doFindJarResources(rootUrl, subPattern));
                }
                return (LinkedHashSet)result.$plus$plus$eq(this.doFindFileResources(rootUrl, subPattern));
            });
            return result.toList();
        }
        String path = location.startsWith("/") ? location.substring(1) : location;
        return ClassLoaders$.MODULE$.getResources(path, ClassLoaders$.MODULE$.getResources$default$2());
    }

    private String determineRootDir(String location) {
        int prefixEnd = location.indexOf(":") + 1;
        int rootDirEnd = location.length();
        while (rootDirEnd > prefixEnd && AntPathPattern$.MODULE$.isPattern(location.substring(prefixEnd, rootDirEnd))) {
            rootDirEnd = location.lastIndexOf(47, rootDirEnd - 2) + 1;
        }
        if (rootDirEnd == 0) {
            rootDirEnd = prefixEnd;
        }
        return location.substring(0, rootDirEnd);
    }

    public URL resolve(URL url) {
        if (this.equinoxResolveMethod != null && url.getProtocol().startsWith("bundle")) {
            return (URL)this.equinoxResolveMethod.invoke(null, url);
        }
        return url;
    }

    public Set<URL> doFindJarResources(URL rootDirResource, AntPathPattern subPattern) {
        LinkedHashSet linkedHashSet;
        URLConnection con = rootDirResource.openConnection();
        JarFile jarFile = null;
        Object rootEntryPath = null;
        boolean newJarFile = false;
        URLConnection uRLConnection = con;
        if (uRLConnection instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)uRLConnection;
            Jars$.MODULE$.useCachesIfNecessary(jarCon);
            jarFile = jarCon.getJarFile();
            JarEntry jarEntry = jarCon.getJarEntry();
            rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
        } else {
            String urlFile = rootDirResource.getFile();
            int separatorIndex = urlFile.indexOf(Jars$.MODULE$.URLSeparator());
            if (separatorIndex != -1) {
                rootEntryPath = urlFile.substring(separatorIndex + Jars$.MODULE$.URLSeparator().length());
                jarFile = Jars$.MODULE$.getJarFile(urlFile.substring(0, separatorIndex));
            } else {
                rootEntryPath = "";
                jarFile = new JarFile(urlFile);
            }
            newJarFile = true;
        }
        try {
            if (!"".equals(rootEntryPath) && !((String)rootEntryPath).endsWith("/")) {
                rootEntryPath = (String)rootEntryPath + "/";
            }
            LinkedHashSet result = new LinkedHashSet();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String relativePath;
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!entryPath.startsWith((String)rootEntryPath) || !subPattern.matches(relativePath = entryPath.substring(((String)rootEntryPath).length()))) continue;
                result.add((Object)Networks$.MODULE$.url(rootDirResource, relativePath));
            }
            linkedHashSet = result;
        }
        finally {
            if (newJarFile) {
                jarFile.close();
            }
        }
        return linkedHashSet;
    }

    public Set<URL> doFindFileResources(URL rootDirURL, AntPathPattern pattern) {
        scala.collection.immutable.Set set;
        try {
            File rootDir = new File(rootDirURL.toURI()).getAbsoluteFile();
            if (!(rootDir.exists() && rootDir.isDirectory() && rootDir.canRead())) {
                return Predef$.MODULE$.Set().empty();
            }
            Object fullPattern = Strings$.MODULE$.replace(rootDir.getAbsolutePath(), File.separator, "/");
            if (!pattern.text().startsWith("/")) {
                fullPattern = (String)fullPattern + "/";
            }
            fullPattern = (String)fullPattern + Strings$.MODULE$.replace(pattern.text(), File.separator, "/");
            LinkedHashSet matchingFiles = new LinkedHashSet();
            this.doRetrieveMatchingFiles(new AntPathPattern((String)fullPattern), rootDir, (scala.collection.mutable.Set<File>)matchingFiles);
            LinkedHashSet result = new LinkedHashSet();
            matchingFiles.foreach((Function1 & Serializable)file -> result.add((Object)file.toURI().toURL()));
            set = result;
        }
        catch (Throwable throwable) {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public void doRetrieveMatchingFiles(AntPathPattern pattern, File dir, scala.collection.mutable.Set<File> result) {
        Object[] dirContents = dir.listFiles();
        if (dirContents != null) {
            Object object = Predef$.MODULE$.refArrayOps(dirContents);
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)content -> {
                String currPath = Strings$.MODULE$.replace(content.getAbsolutePath(), File.separator, "/");
                if (content.isDirectory() && pattern.matchStart(currPath + "/") && content.canRead()) {
                    this.doRetrieveMatchingFiles(pattern, (File)content, result);
                }
                if (pattern.matches(currPath)) {
                    result.add(content);
                    return;
                }
            });
            return;
        }
    }
}

