/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.io;

import java.io.Serializable;
import java.net.URL;
import org.beangle.commons.io.ResourceLoader;
import org.beangle.commons.io.ResourcePatternResolver;
import org.beangle.commons.io.ResourceVersionLoader$;
import org.beangle.commons.lang.Strings$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.List;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class ResourceVersionLoader {
    private final ResourceLoader loader;
    private final ResourcePatternResolver patternResolver;

    public static ResourceLoader $lessinit$greater$default$1() {
        return ResourceVersionLoader$.MODULE$.$lessinit$greater$default$1();
    }

    public ResourceVersionLoader(ResourceLoader loader) {
        this.loader = loader;
        this.patternResolver = new ResourcePatternResolver(loader);
    }

    public Option<URL> getResource(String resourceName, String version) {
        Option<URL> versioned;
        int idxLastDot = resourceName.lastIndexOf(46);
        ObjectRef path = ObjectRef.create((Object)resourceName);
        String suffix = "";
        if (idxLastDot > -1) {
            path.elem = resourceName.substring(0, idxLastDot);
            suffix = resourceName.substring(idxLastDot);
        }
        if ((versioned = this.loader.load((String)path.elem + "_" + version + suffix)).nonEmpty()) {
            return versioned;
        }
        List<URL> urls = this.patternResolver.getResources((String)path.elem + "*" + suffix);
        ObjectRef defaultUrl = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef matched = ObjectRef.create((Object)None$.MODULE$);
        urls.withFilter((Function1 & Serializable)url -> ((Option)matched$1.elem).isEmpty()).foreach((Function1)(JProcedure1 & Serializable)url -> {
            String fullPath = url.getFile();
            if (fullPath.endsWith(resourceName)) {
                defaultUrl$1.elem = Some$.MODULE$.apply(url);
                return;
            }
            String v = Strings$.MODULE$.substringAfter(fullPath, (String)path$1.elem);
            if (v.charAt(0) == '(') {
                String scheme = Strings$.MODULE$.substringBetween(v, "(", ")");
                String[] vp = Strings$.MODULE$.split(scheme, "~");
                if (vp.length == 2 && version.compareTo(vp[0]) >= 0 && version.compareTo(vp[1]) <= 0) {
                    matched$2.elem = Some$.MODULE$.apply(url);
                    return;
                }
                return;
            }
        });
        return ((Option)matched.elem).orElse(() -> ResourceVersionLoader.getResource$$anonfun$3(defaultUrl));
    }

    private static final Option getResource$$anonfun$3(ObjectRef defaultUrl$2) {
        return (Option)defaultUrl$2.elem;
    }
}

