/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.json;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.beangle.commons.bean.DynamicBean;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.conversion.string.TemporalConverter$;
import org.beangle.commons.json.JsonArray;
import org.beangle.commons.json.JsonArray$;
import org.beangle.commons.json.JsonObject$;
import org.beangle.commons.lang.Strings$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapFactoryDefaults;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JsonObject
implements IterableOnce,
IterableOnceOps,
IterableOps,
IterableFactoryDefaults,
Iterable,
Function1,
PartialFunction,
MapOps,
MapFactoryDefaults,
Map,
DynamicBean {
    private final scala.collection.mutable.Map props;

    public static String toLiteral(Object object) {
        return JsonObject$.MODULE$.toLiteral(object);
    }

    public JsonObject() {
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        Iterable.$init$((Iterable)this);
        PartialFunction.$init$((PartialFunction)this);
        MapOps.$init$((MapOps)this);
        MapFactoryDefaults.$init$((MapFactoryDefaults)this);
        Map.$init$((Map)this);
        this.props = Collections$.MODULE$.newMap();
    }

    private scala.collection.mutable.Map<String, Object> props() {
        return this.props;
    }

    public JsonObject(Iterable<Tuple2<String, Object>> v) {
        this();
        v.foreach((Function1 & Serializable)x -> this.add((String)x._1(), x._2()));
    }

    public Option<Object> query(String path) {
        String[] parts = path.charAt(0) == '/' ? Strings$.MODULE$.split(path, "/") : Strings$.MODULE$.split(path, ".");
        Object o = this;
        for (int i = 0; o != null && i < parts.length; ++i) {
            String part = parts[i];
            Object object = o;
            if (object instanceof JsonObject) {
                JsonObject jo = object;
                o = jo.props().getOrElse((Object)part, JsonObject::query$$anonfun$1);
                continue;
            }
            if (object instanceof JsonArray) {
                JsonArray ja = (JsonArray)object;
                o = ja.get(new String[]{part});
                continue;
            }
            o = null;
        }
        return Option$.MODULE$.apply(o);
    }

    public JsonObject update(String path, Object value2) {
        int i;
        String[] parts = path.charAt(0) == '/' ? Strings$.MODULE$.split(path, "/") : Strings$.MODULE$.split(path, ".");
        Object o = this;
        for (i = 0; o != null && i < parts.length - 1; ++i) {
            String part = parts[i];
            int nextIdx = JsonArray$.MODULE$.parseIndex(parts[i + 1]);
            Object object = o;
            if (object instanceof JsonObject) {
                JsonObject jo = object;
                o = jo.props().getOrElseUpdate((Object)part, () -> JsonObject.update$$anonfun$1(nextIdx));
                continue;
            }
            if (object instanceof JsonArray) {
                JsonArray ja = (JsonArray)object;
                int idx = JsonArray$.MODULE$.parseIndex(part);
                Option<Object> option = ja.get(idx);
                if (None$.MODULE$.equals(option)) {
                    o = nextIdx > -1 ? new JsonArray() : new JsonObject();
                    ja.set(idx, o);
                    continue;
                }
                if (option instanceof Some) {
                    Object a;
                    o = a = ((Some)option).value();
                    continue;
                }
                throw new MatchError(option);
            }
            o = null;
        }
        Object cv = this.convert(value2);
        String last = parts[i];
        Object object = o;
        if (object instanceof JsonObject) {
            JsonObject jo = object;
            v0 = jo.add(last, cv);
        } else if (object instanceof JsonArray) {
            JsonArray ja = (JsonArray)object;
            ja.set(JsonArray$.MODULE$.parseIndex(last), cv);
            v0 = BoxedUnit.UNIT;
        } else {
            throw new MatchError(object);
        }
        return this;
    }

    private Object convert(Object value2) {
        Object object = value2;
        if (object instanceof JsonObject) {
            JsonObject jo = (JsonObject)object;
            return jo;
        }
        if (object instanceof JsonArray) {
            JsonArray ja = (JsonArray)object;
            return ja;
        }
        if (object instanceof Iterable) {
            Iterable i = (Iterable)object;
            return new JsonArray((Iterable<Object>)i);
        }
        if (object instanceof Object[]) {
            Object[] a = (Object[])object;
            return new JsonArray((Iterable<Object>)Predef$.MODULE$.genericWrapArray((Object)a));
        }
        if (object instanceof Object) {
            Object v = object;
            return v;
        }
        throw new MatchError(object);
    }

    public JsonObject remove(Seq<String> keys) {
        keys.foreach((Function1 & Serializable)key -> (scala.collection.mutable.Map)this.props().$minus$eq(key));
        return this;
    }

    public Map<String, Object> $minus(String key) {
        this.props().$minus$eq((Object)key);
        return this;
    }

    public Map<String, Object> $minus(String key1, String key2, Seq<String> keys) {
        this.props().$minus$eq((Object)key1);
        this.props().$minus$eq((Object)key2);
        keys.foreach((Function1 & Serializable)key -> (scala.collection.mutable.Map)this.props().$minus$eq(key));
        return this;
    }

    public JsonObject add(String key, Object value2) {
        if (value2 == null) {
            v0 = (scala.collection.mutable.Map)this.props().$minus$eq((Object)key);
        } else {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
            v0 = (scala.collection.mutable.Map)this.props().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, value2));
        }
        return this;
    }

    public JsonObject addAll(Map<String, Object> datas) {
        datas.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                return (scala.collection.mutable.Map)this.props().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, v));
            }
            throw new MatchError((Object)tuple2);
        });
        return this;
    }

    public JsonObject addAll(JsonObject datas) {
        datas.props().foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                return (scala.collection.mutable.Map)this.props().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, v));
            }
            throw new MatchError((Object)tuple2);
        });
        return this;
    }

    public Object apply(String key) {
        return this.props().apply((Object)key);
    }

    public Option<Object> get(String key) {
        return this.props().get((Object)key);
    }

    public String getString(String key, String defaultValue) {
        Option option = this.props().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            return s.toString();
        }
        return defaultValue;
    }

    public String getString$default$2() {
        return "";
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Option option = this.props().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            Object object = s;
            if (object instanceof Boolean) {
                boolean i = BoxesRunTime.unboxToBoolean((Object)object);
                return i;
            }
            if (object instanceof Number) {
                Number n = (Number)object;
                return n.intValue() > 0;
            }
            Object s2 = object;
            return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(s2.toString()));
        }
        return defaultValue;
    }

    public boolean getBoolean$default$2() {
        return false;
    }

    public int getInt(String key, int defaultValue) {
        Option option = this.props().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            Object object = s;
            if (object instanceof Integer) {
                int i = BoxesRunTime.unboxToInt((Object)object);
                return i;
            }
            if (object instanceof Number) {
                Number n = (Number)object;
                return n.intValue();
            }
            Object s2 = object;
            return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s2.toString()));
        }
        return defaultValue;
    }

    public int getInt$default$2() {
        return 0;
    }

    public long getLong(String key, long defaultValue) {
        Option option = this.props().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            Object object = s;
            if (object instanceof Long) {
                long i = BoxesRunTime.unboxToLong((Object)object);
                return i;
            }
            if (object instanceof Number) {
                Number n = (Number)object;
                return n.longValue();
            }
            Object s2 = object;
            return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s2.toString()));
        }
        return defaultValue;
    }

    public long getLong$default$2() {
        return 0L;
    }

    public double getDouble(String key, double defaultValue) {
        Option option = this.props().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            Object object = s;
            if (object instanceof Number) {
                Number n = (Number)object;
                return n.doubleValue();
            }
            Object s2 = object;
            return StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s2.toString()));
        }
        return defaultValue;
    }

    public double getDouble$default$2() {
        return 0.0;
    }

    public LocalDate getDate(String key, LocalDate defaultValue) {
        Option option = this.props().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            return TemporalConverter$.MODULE$.convert(s.toString(), LocalDate.class);
        }
        return defaultValue;
    }

    public LocalDate getDate$default$2() {
        return null;
    }

    public LocalDateTime getDateTime(String key, LocalDateTime defaultValue) {
        Option option = this.props().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            return TemporalConverter$.MODULE$.convert(s.toString(), LocalDateTime.class);
        }
        return defaultValue;
    }

    public LocalDateTime getDateTime$default$2() {
        return null;
    }

    public Instant getInstant(String key, Instant defaultValue) {
        Option option = this.props().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            return TemporalConverter$.MODULE$.convert(s.toString(), Instant.class);
        }
        return defaultValue;
    }

    public Instant getInstant$default$2() {
        return null;
    }

    public JsonObject getObject(String key, JsonObject defaultValue) {
        Option option = this.props().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            return (JsonObject)s;
        }
        if (defaultValue == null) {
            return new JsonObject();
        }
        return defaultValue;
    }

    public JsonObject getObject$default$2() {
        return null;
    }

    public JsonArray getArray(String key) {
        Option option = this.props().get((Object)key);
        if (option instanceof Some) {
            Object s = ((Some)option).value();
            return (JsonArray)s;
        }
        return new JsonArray();
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder("{");
        this.props().foreach((Function1 & Serializable)kv -> {
            sb.append("\"").append((String)kv._1()).append("\":");
            Object object = kv._2();
            if (object instanceof JsonObject) {
                JsonObject o = (JsonObject)object;
                v0 = sb.append(o.toJson());
            } else if (object instanceof JsonArray) {
                JsonArray a = (JsonArray)object;
                v0 = sb.append(a.toJson());
            } else {
                v0 = sb.append(JsonObject$.MODULE$.toLiteral(kv._2()));
            }
            return sb.append(",");
        });
        if (this.props().nonEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.append("}").toString();
    }

    public Iterator<Tuple2<String, Object>> iterator() {
        return this.props().iterator();
    }

    public boolean isMatch(JsonObject target) {
        return target.keys().forall((Function1 & Serializable)k -> {
            Object t = target.apply((String)k);
            if (this.contains(k)) {
                Object object = t;
                if (object instanceof JsonObject) {
                    JsonObject jo = (JsonObject)object;
                    Object object2 = this.apply((String)k);
                    if (object2 instanceof JsonObject) {
                        JsonObject sjo = (JsonObject)object2;
                        return sjo.isMatch(jo);
                    }
                    return false;
                }
                if (object instanceof JsonArray) {
                    JsonArray ja = (JsonArray)object;
                    Object object3 = this.apply((String)k);
                    if (object3 instanceof JsonArray) {
                        JsonArray sja = (JsonArray)object3;
                        return this.isMatch(sja, ja);
                    }
                    if (object3 instanceof JsonObject) {
                        JsonObject sjo = (JsonObject)object3;
                        return false;
                    }
                    if (object3 instanceof Object) {
                        Object v = object3;
                        return ja.contains(v);
                    }
                    throw new MatchError(object3);
                }
                if (object instanceof Object) {
                    Object v = object;
                    return BoxesRunTime.equals((Object)this.apply((String)k), (Object)t);
                }
                throw new MatchError(object);
            }
            return false;
        });
    }

    private boolean isMatch(JsonArray src, JsonArray target) {
        if (src.size() == target.size()) {
            return src.indices().forall((Function1)(JFunction1.mcZI.sp & Serializable)i -> {
                Object si = src.apply(i);
                Object ti = target.apply(i);
                Object object = si;
                if (object instanceof JsonObject) {
                    JsonObject jo = (JsonObject)object;
                    if (ti instanceof JsonObject) {
                        return jo.isMatch((JsonObject)ti);
                    }
                }
                if (object instanceof JsonArray) {
                    JsonArray ja = (JsonArray)object;
                    if (ti instanceof JsonArray) {
                        return this.isMatch(ja, (JsonArray)ti);
                    }
                }
                return BoxesRunTime.equals((Object)si, (Object)ti);
            });
        }
        return false;
    }

    public String toString() {
        return this.toJson();
    }

    private static final Object query$$anonfun$1() {
        return null;
    }

    private static final Object update$$anonfun$1(int nextIdx$1) {
        if (nextIdx$1 > -1) {
            return new JsonArray();
        }
        return new JsonObject();
    }
}

