/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.json;

import java.io.Reader;
import org.beangle.commons.json.JsonArray;
import org.beangle.commons.json.JsonObject;
import org.beangle.commons.json.Null$;
import scala.Char$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public class JsonParser {
    private final Reader reader;
    private int index;
    private int length;
    private final char[] buffer;

    public JsonParser(Reader reader) {
        this.reader = reader;
        this.index = 1;
        this.length = 0;
        this.buffer = new char[1024];
    }

    public Object parse() {
        Object object;
        try {
            char c;
            char c2 = c = this.readChar();
            if ('{' == c2) {
                this.back();
                object = this.parseObject();
            } else if ('[' == c2) {
                this.back();
                object = this.parseArray();
            } else {
                object = this.readValue(c);
            }
        }
        catch (StackOverflowError e) {
            throw new RuntimeException("json array or object depth too large to process.", e);
        }
        return object;
    }

    private char readChar() {
        while (true) {
            char c = this.next();
            if (c != '\u0000' && c <= ' ') continue;
            return c;
        }
        return '\u0000';
    }

    private char next() {
        if (this.index >= this.length) {
            int readLen;
            char last = '\u0000';
            if (this.length > 0) {
                last = this.buffer[this.length - 1];
            }
            this.length = (readLen = this.reader.read(this.buffer, 1, this.buffer.length - 1)) < 0 ? 0 : readLen + 1;
            this.index = 1;
            if (this.length == 0) {
                return '\u0000';
            }
            this.buffer[0] = last;
        }
        char c = this.buffer[this.index];
        ++this.index;
        return c;
    }

    private String readChars(int n) {
        if (n == 0) {
            return "";
        }
        char[] chars = new char[n];
        for (int pos = 0; pos < n; ++pos) {
            chars[pos] = this.next();
            if (!this.end()) continue;
            throw this.syntaxError("Substring bounds error");
        }
        return new String(chars);
    }

    private Object readValue(char c) {
        String string = null;
        char c2 = c;
        if ('\"' == c2 || '\'' == c2) {
            return this.readString(c);
        }
        char c3 = c;
        StringBuilder sb = new StringBuilder();
        while (c3 >= ' ' && ",:]}/\\\"[{;=#".indexOf(Char$.MODULE$.char2int(c3)) < 0) {
            sb.append(c3);
            c3 = this.next();
        }
        if (!this.end()) {
            this.back();
        }
        if ("".equals(string = sb.toString().trim())) {
            throw this.syntaxError("Missing value");
        }
        return this.stringToValue(string);
    }

    private String readString(char quote) {
        char c = '\u0000';
        StringBuilder sb = new StringBuilder();
        boolean bl = false;
        block15: while (!bl) {
            char c2 = c = this.next();
            switch (c2) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string. Character with int code " + c + " is not allowed within a quoted string.");
                }
                case '\\': {
                    char c3 = c = this.next();
                    switch (c3) {
                        case 'b': {
                            sb.append('\b');
                            continue block15;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block15;
                        }
                        case 'n': {
                            sb.append('\n');
                            continue block15;
                        }
                        case 'f': {
                            sb.append('\f');
                            continue block15;
                        }
                        case 'r': {
                            sb.append('\r');
                            continue block15;
                        }
                        case 'u': {
                            String next = this.readChars(4);
                            try {
                                sb.append((char)Integer.parseInt(next, 16));
                                continue block15;
                            }
                            catch (NumberFormatException e) {
                                throw this.syntaxError("Illegal escape. \\u must be followed by a 4 digit hexadecimal number. \\" + next + " is not valid.");
                            }
                        }
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            sb.append(c);
                            continue block15;
                        }
                    }
                    throw this.syntaxError("Illegal escape.\\" + c + " is not valid.");
                }
            }
            if (c == quote) {
                bl = true;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private JsonObject parseObject() {
        JsonObject jo = new JsonObject();
        char c = '\u0000';
        String key = null;
        if (this.readChar() != '{') {
            throw this.syntaxError("A json object text must begin with '{'");
        }
        block5: while (true) {
            Object value2;
            c = this.readChar();
            char c2 = c;
            if ('\u0000' == c2) {
                throw this.syntaxError("A Json object text must end with '}'");
            }
            if ('}' == c2) {
                return jo;
            }
            key = this.readValue(c).toString();
            c = this.readChar();
            if (c != ':') {
                throw this.syntaxError("Expected a ':' after a key");
            }
            if (key != null && (value2 = this.parse()) != null) {
                jo.add(key, value2);
            }
            char c3 = this.readChar();
            switch (c3) {
                case ';': {
                    continue block5;
                }
                case ',': {
                    if (this.readChar() == '}') {
                        return jo;
                    }
                    if (this.end()) {
                        throw this.syntaxError("A json object text must end with '}'");
                    }
                    this.back();
                    continue block5;
                }
                case '}': {
                    return jo;
                }
            }
            char c4 = c3;
            throw this.syntaxError("Expected a ',' or '}',but occurred " + c4);
        }
        return jo;
    }

    private JsonArray parseArray() {
        JsonArray ja = new JsonArray();
        if (this.readChar() != '[') {
            throw this.syntaxError("A jsonArray text must start with '['");
        }
        char nextChar = this.readChar();
        if (nextChar == '\u0000') {
            throw this.syntaxError("Expected a ',' or ']'");
        }
        if (nextChar != ']') {
            this.back();
            block5: while (true) {
                if (this.readChar() == ',') {
                    this.back();
                    ja.add(Null$.MODULE$);
                } else {
                    this.back();
                    ja.add(this.parse());
                }
                char c = this.readChar();
                switch (c) {
                    case '\u0000': {
                        throw this.syntaxError("Expected a ',' or ']'");
                    }
                    case ',': {
                        nextChar = this.readChar();
                        if (nextChar == '\u0000') {
                            throw this.syntaxError("Expected a ',' or ']'");
                        }
                        if (nextChar == ']' || nextChar == ',') {
                            return ja;
                        }
                        this.back();
                        continue block5;
                    }
                    case ']': {
                        return ja;
                    }
                }
                throw this.syntaxError("Expected a ',' or ']'");
            }
        }
        return ja;
    }

    private Object stringToValue(String str) {
        if ("".equals(str)) {
            return str;
        }
        if ("true".equalsIgnoreCase(str)) {
            return BoxesRunTime.boxToBoolean((boolean)true);
        }
        if ("false".equalsIgnoreCase(str)) {
            return BoxesRunTime.boxToBoolean((boolean)false);
        }
        if ("null".equalsIgnoreCase(str)) {
            return Null$.MODULE$;
        }
        char initial = str.charAt(0);
        if (initial >= '0' && initial <= '9' || initial == '-') {
            Object object;
            boolean isDecimal = str.indexOf(46) > -1 || str.indexOf(101) > -1 || str.indexOf(69) > -1 || "-0".equals(str);
            try {
                object = isDecimal ? (Number)Double.valueOf(str) : (Number)Long.valueOf(str);
            }
            catch (Exception exception) {
                object = str;
            }
            return object;
        }
        return str;
    }

    private boolean end() {
        return this.length < 0;
    }

    private void back() {
        if (this.index > 0) {
            --this.index;
            return;
        }
        throw new RuntimeException("Stepping back two steps is not supported");
    }

    private RuntimeException syntaxError(String message) {
        if (this.index < this.length) {
            int len = Math.min(10, this.length - this.index);
            Object object = Predef$.MODULE$.charArrayOps(this.buffer);
            String c = new String((char[])ArrayOps$.MODULE$.slice$extension(object, this.index, this.index + len));
            throw new RuntimeException(message + " -- " + c);
        }
        throw new RuntimeException(message);
    }
}

