/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang.time;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.time.CycleTime$;
import org.beangle.commons.lang.time.CycleTime$CycleTimeType$;
import org.beangle.commons.lang.time.HourMinute;
import org.beangle.commons.lang.time.WeekTime;
import org.beangle.commons.lang.time.WeekTime$;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.reflect.Enum;

public class CycleTime
implements Cloneable,
Serializable {
    private LocalDate beginOn;
    private LocalDate endOn;
    private HourMinute beginAt;
    private HourMinute endAt;
    private CycleTimeType cycleType;
    private int cycleCount;

    public static CycleTime apply(LocalDate localDate, LocalDate localDate2, HourMinute hourMinute, HourMinute hourMinute2, int n, CycleTimeType cycleTimeType) {
        return CycleTime$.MODULE$.apply(localDate, localDate2, hourMinute, hourMinute2, n, cycleTimeType);
    }

    public static int apply$default$5() {
        return CycleTime$.MODULE$.apply$default$5();
    }

    public static CycleTimeType apply$default$6() {
        return CycleTime$.MODULE$.apply$default$6();
    }

    public LocalDate beginOn() {
        return this.beginOn;
    }

    public void beginOn_$eq(LocalDate x$1) {
        this.beginOn = x$1;
    }

    public LocalDate endOn() {
        return this.endOn;
    }

    public void endOn_$eq(LocalDate x$1) {
        this.endOn = x$1;
    }

    public HourMinute beginAt() {
        return this.beginAt;
    }

    public void beginAt_$eq(HourMinute x$1) {
        this.beginAt = x$1;
    }

    public HourMinute endAt() {
        return this.endAt;
    }

    public void endAt_$eq(HourMinute x$1) {
        this.endAt = x$1;
    }

    public CycleTimeType cycleType() {
        return this.cycleType;
    }

    public void cycleType_$eq(CycleTimeType x$1) {
        this.cycleType = x$1;
    }

    public int cycleCount() {
        return this.cycleCount;
    }

    public void cycleCount_$eq(int x$1) {
        this.cycleCount = x$1;
    }

    public boolean isOneDay() {
        LocalDate localDate = this.beginOn();
        LocalDate localDate2 = this.endOn();
        return !(localDate != null ? !((Object)localDate).equals(localDate2) : localDate2 != null);
    }

    public int getCycleDays() {
        CycleTimeType cycleTimeType = this.cycleType();
        CycleTimeType cycleTimeType2 = CycleTime$CycleTimeType$.Day;
        CycleTimeType cycleTimeType3 = cycleTimeType;
        if (!(cycleTimeType2 != null ? !cycleTimeType2.equals(cycleTimeType3) : cycleTimeType3 != null)) {
            return this.cycleCount();
        }
        CycleTimeType cycleTimeType4 = CycleTime$CycleTimeType$.Month;
        CycleTimeType cycleTimeType5 = cycleTimeType;
        if (!(cycleTimeType4 != null ? !cycleTimeType4.equals(cycleTimeType5) : cycleTimeType5 != null)) {
            return this.cycleCount() * 30;
        }
        CycleTimeType cycleTimeType6 = CycleTime$CycleTimeType$.Week;
        CycleTimeType cycleTimeType7 = cycleTimeType;
        if (!(cycleTimeType6 != null ? !cycleTimeType6.equals(cycleTimeType7) : cycleTimeType7 != null)) {
            return this.cycleCount() * 7;
        }
        throw new MatchError((Object)cycleTimeType);
    }

    public List<WeekTime> convert() {
        ToWeekTimeBuilder builder = new ToWeekTimeBuilder(this.beginAt(), this.endAt());
        builder.addRange(this.beginOn(), this.endOn(), this.cycleType(), this.cycleCount());
        return builder.build();
    }

    public static abstract class CycleTimeType
    implements Product,
    Enum {
        private final int id;

        public static CycleTimeType fromOrdinal(int n) {
            return CycleTime$CycleTimeType$.MODULE$.fromOrdinal(n);
        }

        public static CycleTimeType valueOf(String string) {
            return CycleTime$CycleTimeType$.MODULE$.valueOf(string);
        }

        public static CycleTimeType[] values() {
            return CycleTime$CycleTimeType$.MODULE$.values();
        }

        public CycleTimeType() {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }

    public static class ToWeekTimeBuilder {
        private final HourMinute beginAt;
        private final HourMinute endAt;
        private final Buffer<WeekTime> times;

        public ToWeekTimeBuilder(HourMinute beginAt, HourMinute endAt) {
            this.beginAt = beginAt;
            this.endAt = endAt;
            this.times = Collections$.MODULE$.newBuffer();
        }

        public List<WeekTime> build() {
            return this.times.toList();
        }

        public void add(LocalDate start) {
            WeekTime time = WeekTime$.MODULE$.of(start, this.beginAt, this.endAt);
            if (this.times.isEmpty()) {
                this.times.$plus$eq((Object)time);
                return;
            }
            Option option = this.times.find(arg_0 -> CycleTime$.org$beangle$commons$lang$time$CycleTime$ToWeekTimeBuilder$$_$add$$anonfun$1(time, arg_0));
            if (option instanceof Some) {
                WeekTime t = (WeekTime)((Some)option).value();
                t.merge(time, 15);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.times.$plus$eq((Object)time);
                return;
            }
            throw new MatchError((Object)option);
        }

        public void addRange(LocalDate start, LocalDate end, CycleTimeType cycleType, int count) {
            LocalDate startOn = start;
            Predef$.MODULE$.require(count > 0, CycleTime$::org$beangle$commons$lang$time$CycleTime$ToWeekTimeBuilder$$_$addRange$$anonfun$1);
            while (!startOn.isAfter(end)) {
                this.add(startOn);
                CycleTimeType cycleTimeType = cycleType;
                CycleTimeType cycleTimeType2 = CycleTime$CycleTimeType$.Day;
                CycleTimeType cycleTimeType3 = cycleTimeType;
                if (!(cycleTimeType2 != null ? !cycleTimeType2.equals(cycleTimeType3) : cycleTimeType3 != null)) {
                    startOn = startOn.plusDays(Int$.MODULE$.int2long(count));
                    continue;
                }
                CycleTimeType cycleTimeType4 = CycleTime$CycleTimeType$.Week;
                CycleTimeType cycleTimeType5 = cycleTimeType;
                if (!(cycleTimeType4 != null ? !cycleTimeType4.equals(cycleTimeType5) : cycleTimeType5 != null)) {
                    startOn = startOn.plusWeeks(Int$.MODULE$.int2long(count));
                    continue;
                }
                CycleTimeType cycleTimeType6 = CycleTime$CycleTimeType$.Month;
                CycleTimeType cycleTimeType7 = cycleTimeType;
                if (!(cycleTimeType6 != null ? !cycleTimeType6.equals(cycleTimeType7) : cycleTimeType7 != null)) {
                    startOn = startOn.plusMonths(Int$.MODULE$.int2long(count));
                    continue;
                }
                throw new MatchError((Object)cycleTimeType);
            }
        }

        public int addRange$default$4() {
            return 1;
        }
    }
}

