/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang.time;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.time.CycleTime;
import org.beangle.commons.lang.time.CycleTime$;
import org.beangle.commons.lang.time.CycleTime$CycleTimeType$;
import org.beangle.commons.lang.time.HourMinute;
import org.beangle.commons.lang.time.WeekDay;
import org.beangle.commons.lang.time.WeekDay$;
import org.beangle.commons.lang.time.WeekTime;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class CycleTimeDigest$
implements Serializable {
    private static final Map<String, String> wMap;
    private static final DateTimeFormatter format;
    private static final DateTimeFormatter format2;
    public static final CycleTimeDigest$ MODULE$;

    private CycleTimeDigest$() {
    }

    static {
        MODULE$ = new CycleTimeDigest$();
        Object[] objectArray = new Tuple2[7];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Mon");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"\u4e00");
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Tue");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)"\u4e8c");
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Wed");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)"\u4e09");
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Thu");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)"\u56db");
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Fri");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)"\u4e94");
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Sat");
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)"\u516d");
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Sun");
        objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)"\u65e5");
        wMap = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        format = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        format2 = DateTimeFormatter.ofPattern("MM-dd");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CycleTimeDigest$.class);
    }

    public String digest(Seq<WeekTime> times, String delimeter) {
        if (times.isEmpty()) {
            return "";
        }
        Buffer timeList = Collections$.MODULE$.newBuffer();
        HashMap timeMap = new HashMap();
        times.foreach((Function1 & Serializable)t -> {
            HashSet dates = (HashSet)timeMap.getOrElseUpdate((Object)Tuple2$.MODULE$.apply((Object)t.beginAt(), (Object)t.endAt()), CycleTimeDigest$::$anonfun$1);
            return dates.addAll(t.dates());
        });
        ArrayBuffer cycleTimes = new ArrayBuffer();
        timeMap.foreach((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$12;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                HourMinute b = (HourMinute)tuple2._1();
                HourMinute e = (HourMinute)tuple2._2();
                HashSet dates = (HashSet)tuple22._2();
                if (dates.size() == 1) {
                    return cycleTimes.addOne((Object)CycleTime$.MODULE$.apply((LocalDate)dates.head(), (LocalDate)dates.head(), b, e, 1, CycleTime$CycleTimeType$.Day));
                }
                ArrayBuffer dateList = new ArrayBuffer();
                dateList.addAll((IterableOnce)dates).sortInPlace(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                Map<Object, Object> intervalMap = MODULE$.calcIntervals((Seq<LocalDate>)dateList);
                if (intervalMap.size() == 1) {
                    int period = ((Tuple2)intervalMap.head())._1$mcI$sp();
                    if (period % 7 == 0) {
                        return cycleTimes.addOne((Object)CycleTime$.MODULE$.apply((LocalDate)dateList.head(), (LocalDate)dateList.last(), b, e, period / 7, CycleTime$CycleTimeType$.Week));
                    }
                    return cycleTimes.addOne((Object)CycleTime$.MODULE$.apply((LocalDate)dateList.head(), (LocalDate)dateList.last(), b, e, period, CycleTime$CycleTimeType$.Day));
                }
                dateList.groupBy((Function1 & Serializable)_$1 -> _$1.getDayOfWeek()).foreach((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        DayOfWeek dofw = (DayOfWeek)tuple2._1();
                        ArrayBuffer wdates = (ArrayBuffer)tuple2._2();
                        Map<Object, Object> wIntervalMap = MODULE$.calcIntervals((Seq<LocalDate>)wdates);
                        if (wIntervalMap.size() == 1) {
                            int period = ((Tuple2)wIntervalMap.head())._1$mcI$sp();
                            return cycleTimes.addOne((Object)CycleTime$.MODULE$.apply((LocalDate)wdates.head(), (LocalDate)wdates.last(), b, e, period / 7, CycleTime$CycleTimeType$.Week));
                        }
                        wdates.foreach((Function1 & Serializable)d -> cycleTimes.addOne((Object)CycleTime$.MODULE$.apply((LocalDate)d, (LocalDate)d, b, e, CycleTime$.MODULE$.apply$default$5(), CycleTime$.MODULE$.apply$default$6())));
                        return BoxedUnit.UNIT;
                    }
                    throw new MatchError((Object)tuple2);
                });
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple22);
        });
        ((IterableOnceOps)cycleTimes.sortBy((Function1 & Serializable)x -> x.beginOn().toString() + x.beginAt().toString(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable)cd -> {
            StringBuilder sb = new StringBuilder();
            if (cd.isOneDay()) {
                v0 = sb.append(cd.endOn().format(format));
            } else {
                sb.append(cd.beginOn().format(format));
                sb.append("~");
                StringBuilder stringBuilder = cd.beginOn().getYear() == cd.endOn().getYear() ? sb.append("").append(cd.endOn().format(format2)) : sb.append("").append(cd.endOn().format(format));
                CycleTime.CycleTimeType cycleTimeType = cd.cycleType();
                CycleTime.CycleTimeType cycleTimeType2 = CycleTime$CycleTimeType$.Week;
                if (!(cycleTimeType != null ? !cycleTimeType.equals(cycleTimeType2) : cycleTimeType2 != null)) {
                    StringBuilder stringBuilder2 = cd.cycleCount() != 1 ? sb.append(" \u6bcf" + cd.cycleCount() + "\u5468\u5468") : sb.append(" \u6bcf\u5468");
                    WeekDay wd = WeekDay$.MODULE$.of(cd.beginOn());
                    v0 = sb.append((String)wMap.apply((Object)wd.toString()));
                } else if (cd.cycleCount() == 1) {
                    LocalDate localDate = cd.beginOn();
                    LocalDate localDate2 = cd.endOn();
                    if (localDate == null ? localDate2 != null : !((Object)localDate).equals(localDate2)) {
                        sb.append(" \u6bcf\u5929");
                        v0 = BoxedUnit.UNIT;
                    } else {
                        v0 = BoxedUnit.UNIT;
                    }
                } else {
                    v0 = sb.append(" \u6bcf" + cd.cycleCount() + "\u5929");
                }
            }
            sb.append(" ");
            sb.append((Object)cd.beginAt());
            sb.append("~");
            sb.append((Object)cd.endAt());
            return (Buffer)timeList.$plus$eq((Object)sb.toString());
        });
        return Strings$.MODULE$.join((Iterable<?>)timeList, delimeter);
    }

    public String digest$default$2() {
        return ",";
    }

    private Map<Object, Object> calcIntervals(Seq<LocalDate> dates) {
        HashMap intervalMap = new HashMap();
        ObjectRef head = ObjectRef.create(null);
        dates.foreach((Function1)(JProcedure1 & Serializable)d -> {
            if ((LocalDate)head$1.elem != null) {
                int i = Math.abs(Predef$.MODULE$.long2Long(ChronoUnit.DAYS.between((Temporal)d, (LocalDate)head$1.elem)).intValue());
                intervalMap.put((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)intervalMap.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)i), CycleTimeDigest$::calcIntervals$$anonfun$1$$anonfun$1)) + 1)));
            }
            head$1.elem = d;
        });
        return intervalMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final HashSet $anonfun$1() {
        return new HashSet();
    }

    private static final int calcIntervals$$anonfun$1$$anonfun$1() {
        return 0;
    }
}

