/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang.time;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Int$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ModuleSerializationProxy;

public final class InternetDateFormat$
implements Serializable {
    private static final DecimalFormat df2;
    private static final DecimalFormat df3;
    private static final DecimalFormat df4;
    private static final Pattern pattern;
    public static final InternetDateFormat$ MODULE$;

    private InternetDateFormat$() {
    }

    static {
        MODULE$ = new InternetDateFormat$();
        df2 = new DecimalFormat("00");
        df3 = new DecimalFormat("000");
        df4 = new DecimalFormat("0000");
        pattern = MODULE$.buildPattern();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(InternetDateFormat$.class);
    }

    public DecimalFormat df2() {
        return df2;
    }

    public DecimalFormat df3() {
        return df3;
    }

    public DecimalFormat df4() {
        return df4;
    }

    public Pattern pattern() {
        return pattern;
    }

    private Pattern buildPattern() {
        String reDate = "(\\d{4})-(\\d{2})-(\\d{2})";
        String reTime = "(\\d{2}):(\\d{2}):(\\d{2})(\\.\\d+)?";
        String reZone = "(?:([zZ])|(?:(\\+|\\-)(\\d{2}):(\\d{2})))";
        String re = reDate + "[tT\\s]" + reTime + reZone;
        return Pattern.compile(re);
    }

    private void parse(String s, Calendar cal) {
        Matcher m = this.pattern().matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid date/time: " + s);
        }
        cal.clear();
        cal.set(1, Integer.parseInt(m.group(1)));
        cal.set(2, Integer.parseInt(m.group(2)) - 1);
        cal.set(5, Integer.parseInt(m.group(3)));
        cal.set(11, Integer.parseInt(m.group(4)));
        cal.set(12, Integer.parseInt(m.group(5)));
        cal.set(13, Integer.parseInt(m.group(6)));
        if (m.group(7) != null) {
            float fraction = Float.parseFloat(m.group(7));
            cal.set(14, (int)(fraction * 1000.0f));
        }
        if (m.group(8) != null) {
            cal.setTimeZone(new SimpleTimeZone(0, "Z"));
            return;
        }
        int sign = m.group(9).equals("-") ? -1 : 1;
        int tzhour = Integer.parseInt(m.group(10));
        int tzminute = Integer.parseInt(m.group(11));
        int offset = sign * (tzhour * 60 + tzminute);
        String id = Integer.toString(offset);
        cal.setTimeZone(new SimpleTimeZone(offset * 60000, id));
    }

    public Calendar parse(String s) {
        GregorianCalendar cal = new GregorianCalendar();
        this.parse(s, cal);
        return cal;
    }

    public String format(Calendar cal) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.df4().format(Int$.MODULE$.int2long(cal.get(1))));
        buf.append("-");
        buf.append(this.df2().format(Int$.MODULE$.int2long(cal.get(2) + 1)));
        buf.append("-");
        buf.append(this.df2().format(Int$.MODULE$.int2long(cal.get(5))));
        buf.append("T");
        buf.append(this.df2().format(Int$.MODULE$.int2long(cal.get(11))));
        buf.append(":");
        buf.append(this.df2().format(Int$.MODULE$.int2long(cal.get(12))));
        buf.append(":");
        buf.append(this.df2().format(Int$.MODULE$.int2long(cal.get(13))));
        int ms = cal.get(14);
        buf.append(".").append(this.df3().format(Int$.MODULE$.int2long(ms)));
        int tzminute = (cal.get(15) + cal.get(16)) / 60000;
        if (tzminute == 0) {
            v0 = buf.append("Z");
        } else {
            if (tzminute < 0) {
                tzminute = -tzminute;
                v1 = buf.append("-");
            } else {
                v1 = buf.append("+");
            }
            int tzhour = tzminute / 60;
            buf.append(this.df2().format(Int$.MODULE$.int2long(tzhour)));
            buf.append(":");
            v0 = buf.append(this.df2().format(Int$.MODULE$.int2long(tzminute -= tzhour * 60)));
        }
        return buf.toString();
    }

    public String format(Date date, TimeZone zone) {
        GregorianCalendar cal = new GregorianCalendar(zone);
        cal.setTime(date);
        return this.format(cal);
    }
}

